/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core.priority;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.text.quicksearch.internal.core.preferences.QuickSearchPreferences;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;

public class DefaultPriorityFunction
extends PriorityFunction {
    public boolean ignoreDerived = true;
    public String[] ignoredExtensions = new String[]{"~", ".bin", ".bmp", ".class", ".com", ".doc", ".docx", ".exe", ".gif", ".jar", ".jpg", ".jpeg", ".odp", ".odt", ".p12", ".pdf", ".png", ".ppt", ".pptx", ".psd", ".svg", ".xls", ".xlsx", ".zip"};
    public String[] ignoredPrefixes = new String[]{"."};
    public String[] ignoredNames = new String[]{"bin", "build", "target"};

    @Override
    public double priority(IResource r) {
        if (r != null && r.isAccessible()) {
            if (this.ignoreDerived && r.isDerived()) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.isIgnoredLinkedContainer(r)) {
                return Double.NEGATIVE_INFINITY;
            }
            String name = r.getName();
            String[] stringArray = this.ignoredExtensions;
            int n = this.ignoredExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (name.regionMatches(true, name.length() - ext.length(), ext, 0, ext.length())) {
                    return Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
            stringArray = this.ignoredPrefixes;
            n = this.ignoredPrefixes.length;
            n2 = 0;
            while (n2 < n) {
                String pre = stringArray[n2];
                if (name.startsWith(pre)) {
                    return Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
            stringArray = this.ignoredNames;
            n = this.ignoredNames.length;
            n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (name.equals(n3)) {
                    return Double.NEGATIVE_INFINITY;
                }
                ++n2;
            }
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean isIgnoredLinkedContainer(IResource resource) {
        if (!(resource instanceof IContainer) || !resource.isLinked(0)) {
            return false;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return true;
        }
        IWorkspaceRoot root = resource.getWorkspace().getRoot();
        IContainer linkTarget = root.getContainerForLocation(location);
        return linkTarget != null;
    }

    public void configure(QuickSearchPreferences preferences) {
        String[] pref = preferences.getIgnoredExtensions();
        if (pref != null) {
            this.ignoredExtensions = pref;
        }
        if ((pref = preferences.getIgnoredNames()) != null) {
            this.ignoredNames = pref;
        }
        if ((pref = preferences.getIgnoredPrefixes()) != null) {
            this.ignoredPrefixes = pref;
        }
    }
}

