/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.api.ldap.aci.ItemPermission;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.ItemPermissionDialog;
import org.apache.directory.studio.aciitemeditor.model.UserClassWrapper;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ACIItemItemPermissionsComposite
extends Composite {
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private TableViewer tableViewer = null;
    private Button editButton = null;
    private Button deleteButton = null;
    private List<ItemPermissionWrapper> itemPermissionWrappers = new ArrayList<ItemPermissionWrapper>();

    public ACIItemItemPermissionsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(Messages.getString("ACIItemItemPermissionsComposite.description"));
        label.setLayoutData((Object)labelGridData);
        this.createTable();
        this.createButtonComposite();
    }

    private void createTable() {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        Table table = new Table(this.composite, 2048);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)tableGridData);
        table.setLinesVisible(false);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setInput(this.itemPermissionWrappers);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ACIItemItemPermissionsComposite.this.itemPermissionSelected();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ACIItemItemPermissionsComposite.this.editItemPermission();
            }
        });
    }

    private void createButtonComposite() {
        GridData deleteButtonGridData = new GridData();
        deleteButtonGridData.horizontalAlignment = 4;
        deleteButtonGridData.grabExcessHorizontalSpace = false;
        deleteButtonGridData.verticalAlignment = 1;
        deleteButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData addButtonGridData = new GridData();
        addButtonGridData.horizontalAlignment = 4;
        addButtonGridData.grabExcessHorizontalSpace = false;
        addButtonGridData.verticalAlignment = 1;
        addButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        Composite buttonComposite = new Composite(this.composite, 0);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)gridLayout);
        Button addButton = new Button(buttonComposite, 0);
        addButton.setText(Messages.getString("ACIItemItemPermissionsComposite.add.button"));
        addButton.setLayoutData((Object)addButtonGridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemItemPermissionsComposite.this.addItemPermission();
            }
        });
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setText(Messages.getString("ACIItemItemPermissionsComposite.edit.button"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemItemPermissionsComposite.this.editItemPermission();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setText(Messages.getString("ACIItemItemPermissionsComposite.delete.button"));
        this.deleteButton.setLayoutData((Object)deleteButtonGridData);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ACIItemItemPermissionsComposite.this.deleteItemPermission();
            }
        });
        this.deleteButton.setEnabled(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    public void setContext(ACIItemValueWithContext context) {
        this.context = context;
    }

    public void setItemPermissions(Collection<ItemPermission> itemPermissions) {
        this.itemPermissionWrappers.clear();
        for (ItemPermission itemPermission : itemPermissions) {
            ItemPermissionWrapper itemPermissionWrapper = new ItemPermissionWrapper(itemPermission);
            this.itemPermissionWrappers.add(itemPermissionWrapper);
        }
        this.tableViewer.refresh();
    }

    public Collection<ItemPermission> getItemPermissions() {
        ArrayList<ItemPermission> itemPermissions = new ArrayList<ItemPermission>();
        for (ItemPermissionWrapper itemPermissionWrapper : this.itemPermissionWrappers) {
            itemPermissions.add(itemPermissionWrapper.itemPermission);
        }
        return itemPermissions;
    }

    private ItemPermissionWrapper getSelectedItemPermissionWrapper() {
        Object element;
        ItemPermissionWrapper itemPermissionWrapper = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof ItemPermissionWrapper) {
            itemPermissionWrapper = (ItemPermissionWrapper)element;
        }
        return itemPermissionWrapper;
    }

    private void addItemPermission() {
        ItemPermissionDialog dialog = new ItemPermissionDialog(this.getShell(), null, this.context);
        if (dialog.open() == 0 && dialog.getItemPermission() != null) {
            ItemPermissionWrapper itemPermissionWrapper = new ItemPermissionWrapper(dialog.getItemPermission());
            this.itemPermissionWrappers.add(itemPermissionWrapper);
            this.tableViewer.refresh();
        }
    }

    private void editItemPermission() {
        ItemPermissionDialog dialog;
        ItemPermissionWrapper oldItemPermissionWrapper = this.getSelectedItemPermissionWrapper();
        if (oldItemPermissionWrapper != null && (dialog = new ItemPermissionDialog(this.getShell(), oldItemPermissionWrapper.itemPermission, this.context)).open() == 0) {
            oldItemPermissionWrapper.itemPermission = dialog.getItemPermission();
            this.tableViewer.refresh();
        }
    }

    private void deleteItemPermission() {
        ItemPermissionWrapper itemPermissionWrapper = this.getSelectedItemPermissionWrapper();
        if (itemPermissionWrapper != null) {
            this.itemPermissionWrappers.remove(itemPermissionWrapper);
            this.tableViewer.refresh();
        }
    }

    private void itemPermissionSelected() {
        ItemPermissionWrapper itemPermissionWrapper = this.getSelectedItemPermissionWrapper();
        if (itemPermissionWrapper == null) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private class ItemPermissionWrapper {
        private ItemPermission itemPermission;

        private ItemPermissionWrapper(ItemPermission itemPermission) {
            this.itemPermission = itemPermission;
        }

        public String toString() {
            if (this.itemPermission == null) {
                return "<UNKNOWN>";
            }
            StringBuilder buffer = new StringBuilder();
            if (this.itemPermission.getPrecedence() != null && this.itemPermission.getPrecedence() > -1) {
                buffer.append('(');
                buffer.append(this.itemPermission.getPrecedence());
                buffer.append(") ");
            }
            boolean isFirst = true;
            for (UserClass userClass : this.itemPermission.getUserClasses()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(',');
                }
                String s = UserClassWrapper.CLASS_TO_DISPLAY_MAP.get(userClass.getClass());
                buffer.append(s);
            }
            buffer.append(": ");
            isFirst = true;
            for (GrantAndDenial grantAndDenial : this.itemPermission.getGrantsAndDenials()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(',');
                }
                if (grantAndDenial.isGrant()) {
                    buffer.append('+');
                } else {
                    buffer.append('-');
                }
                buffer.append(grantAndDenial.getMicroOperation().getName());
            }
            String s = buffer.toString();
            s = s.replace('\r', ' ');
            if ((s = s.replace('\n', ' ')).length() > 50) {
                String temp = s;
                s = temp.substring(0, 25);
                s = String.valueOf(s) + "...";
                s = String.valueOf(s) + temp.substring(temp.length() - 25, temp.length());
            }
            return s;
        }
    }
}

