/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.hierarchy.HierarchyManager;
import org.apache.directory.studio.schemaeditor.view.wrappers.AbstractTreeNode;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.FirstNameSorter;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.OidSorter;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaSorter;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaViewRoot;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SchemaViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private FirstNameSorter firstNameSorter = new FirstNameSorter();
    private OidSorter oidSorter = new OidSorter();
    private SchemaSorter schemaSorter = new SchemaSorter();
    private SchemaViewRoot root;
    private ListValuedMap<Object, TreeNode> elementsToWrappersMap;
    private HierarchyManager hierarchyManager;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> children = new ArrayList();
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
        int sortBy = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY);
        int sortOrder = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER);
        if (parentElement instanceof SchemaViewRoot) {
            this.root = (SchemaViewRoot)parentElement;
            if (presentation == 0) {
                if (this.root.getChildren().isEmpty()) {
                    this.elementsToWrappersMap = new ArrayListValuedHashMap();
                    SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
                    if (schemaHandler != null) {
                        List<Schema> schemas = schemaHandler.getSchemas();
                        for (Schema schema : schemas) {
                            this.addSchemaFlatPresentation(schema);
                        }
                    }
                }
                children = this.root.getChildren();
                Collections.sort(children, this.schemaSorter);
            } else if (presentation == 1) {
                if (this.root.getChildren().isEmpty()) {
                    this.elementsToWrappersMap = new ArrayListValuedHashMap();
                    this.hierarchyManager = new HierarchyManager();
                    if (group == 0) {
                        Folder atFolder = new Folder(Folder.FolderType.ATTRIBUTE_TYPE, this.root);
                        Folder ocFolder = new Folder(Folder.FolderType.OBJECT_CLASS, this.root);
                        this.root.addChild(atFolder);
                        this.root.addChild(ocFolder);
                        List<Object> rootChildren = this.hierarchyManager.getChildren(this.hierarchyManager.getRootObject());
                        if (rootChildren != null && rootChildren.size() > 0) {
                            for (Object rootChild : rootChildren) {
                                AbstractTreeNode childNode = null;
                                if (rootChild instanceof AttributeType) {
                                    AttributeType at = (AttributeType)rootChild;
                                    childNode = new AttributeTypeWrapper(at, atFolder);
                                    atFolder.addChild(childNode);
                                } else if (rootChild instanceof ObjectClass) {
                                    ObjectClass oc = (ObjectClass)rootChild;
                                    childNode = new ObjectClassWrapper(oc, ocFolder);
                                    ocFolder.addChild(childNode);
                                }
                                this.elementsToWrappersMap.put(rootChild, childNode);
                                this.addHierarchyChildren(childNode, this.hierarchyManager.getChildren(rootChild));
                            }
                        }
                    } else if (group == 1) {
                        this.addHierarchyChildren(this.root, this.hierarchyManager.getChildren(this.hierarchyManager.getRootObject()));
                    }
                }
                children = this.root.getChildren();
                if (group == 1) {
                    if (sortBy == 0) {
                        Collections.sort(children, this.firstNameSorter);
                    } else if (sortBy == 1) {
                        Collections.sort(children, this.oidSorter);
                    }
                    if (sortOrder == 1) {
                        Collections.reverse(children);
                    }
                }
            }
        } else if (parentElement instanceof Folder) {
            children = ((TreeNode)parentElement).getChildren();
            if (sortBy == 0) {
                Collections.sort(children, this.firstNameSorter);
            } else if (sortBy == 1) {
                Collections.sort(children, this.oidSorter);
            }
            if (sortOrder == 1) {
                Collections.reverse(children);
            }
        } else if (parentElement instanceof AttributeTypeWrapper || parentElement instanceof ObjectClassWrapper) {
            children = ((TreeNode)parentElement).getChildren();
            if (sortBy == 0) {
                Collections.sort(children, this.firstNameSorter);
            } else if (sortBy == 1) {
                Collections.sort(children, this.oidSorter);
            }
            if (sortOrder == 1) {
                Collections.reverse(children);
            }
        } else if (parentElement instanceof SchemaWrapper) {
            children = ((TreeNode)parentElement).getChildren();
            if (group == 1) {
                if (sortBy == 0) {
                    Collections.sort(children, this.firstNameSorter);
                } else if (sortBy == 1) {
                    Collections.sort(children, this.oidSorter);
                }
                if (sortOrder == 1) {
                    Collections.reverse(children);
                }
            }
        }
        return children.toArray();
    }

    private void addHierarchyChildren(TreeNode node, List<Object> children) {
        if (children != null && children.size() > 0) {
            for (Object child : children) {
                AbstractTreeNode childNode = null;
                if (child instanceof AttributeType) {
                    AttributeType at = (AttributeType)child;
                    childNode = new AttributeTypeWrapper(at, node);
                    node.addChild(childNode);
                } else if (child instanceof ObjectClass) {
                    ObjectClass oc = (ObjectClass)child;
                    childNode = new ObjectClassWrapper(oc, node);
                    node.addChild(childNode);
                }
                this.elementsToWrappersMap.put(child, childNode);
                this.addHierarchyChildren(childNode, this.hierarchyManager.getChildren(child));
            }
        }
    }

    public Object getParent(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public List<TreeNode> getWrappers(Object o) {
        return this.elementsToWrappersMap.get(o);
    }

    public TreeNode getWrapper(Object o) {
        List<TreeNode> wrappers = this.getWrappers(o);
        if (wrappers != null && wrappers.size() > 0) {
            return wrappers.get(0);
        }
        return null;
    }

    public SchemaViewRoot getRoot() {
        return this.root;
    }

    public void addElementToWrapper(Object element, TreeNode wrapper) {
        this.elementsToWrappersMap.put(element, (Object)wrapper);
    }

    public void removeElementToWrapper(Object element, TreeNode wrapper) {
        this.elementsToWrappersMap.removeMapping(element, (Object)wrapper);
    }

    public void removeElementToWrapper(Object element) {
        this.elementsToWrappersMap.remove(element);
    }

    public void attributeTypeAdded(AttributeType at) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.attributeTypeAddedFlatPresentation(at);
        } else if (presentation == 1) {
            this.attributeTypeAddedHierarchicalPresentation(at);
        }
    }

    public void attributeTypeAddedFlatPresentation(AttributeType at) {
        SchemaWrapper schemaWrapper = (SchemaWrapper)this.getWrapper((Object)Activator.getDefault().getSchemaHandler().getSchema(at.getSchemaName()));
        if (schemaWrapper != null) {
            AbstractTreeNode atw = null;
            int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
            if (group == 0) {
                for (TreeNode child : schemaWrapper.getChildren()) {
                    if (((Folder)child).getType() != Folder.FolderType.ATTRIBUTE_TYPE) continue;
                    atw = new AttributeTypeWrapper(at, child);
                    break;
                }
            } else if (group == 1) {
                atw = new AttributeTypeWrapper(at, schemaWrapper);
            }
            atw.getParent().addChild(atw);
            this.elementsToWrappersMap.put((Object)at, (Object)atw);
        }
    }

    public void attributeTypeAddedHierarchicalPresentation(AttributeType at) {
        List<Object> children;
        this.hierarchyManager.attributeTypeAdded(at);
        ArrayList<AttributeTypeWrapper> createdWrappers = new ArrayList<AttributeTypeWrapper>();
        List<Object> parents = this.hierarchyManager.getParents(at);
        if (parents != null) {
            for (Object parent : parents) {
                AttributeTypeWrapper parentATW = (AttributeTypeWrapper)this.getWrapper(parent);
                AttributeTypeWrapper atw = null;
                if (parentATW == null) {
                    int n = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                    if (n == 0) {
                        for (TreeNode child : this.root.getChildren()) {
                            Folder folder;
                            if (!(child instanceof Folder) || !(folder = (Folder)child).getType().equals((Object)Folder.FolderType.ATTRIBUTE_TYPE)) continue;
                            atw = new AttributeTypeWrapper(at, folder);
                            break;
                        }
                    } else if (n == 1) {
                        atw = new AttributeTypeWrapper(at, this.root);
                    }
                } else {
                    atw = new AttributeTypeWrapper(at, parentATW);
                }
                atw.getParent().addChild(atw);
                createdWrappers.add(atw);
                this.elementsToWrappersMap.put((Object)at, (Object)atw);
            }
        }
        if ((children = this.hierarchyManager.getChildren(at)) != null) {
            for (Object child : children) {
                AttributeTypeWrapper childATW = (AttributeTypeWrapper)this.getWrapper(child);
                this.elementsToWrappersMap.remove(child);
                childATW.getParent().removeChild(childATW);
                for (TreeNode treeNode : createdWrappers) {
                    AttributeTypeWrapper atw = new AttributeTypeWrapper((AttributeType)child, treeNode);
                    atw.getParent().addChild(atw);
                    this.elementsToWrappersMap.put(child, (Object)atw);
                }
            }
        }
    }

    public void attributeTypeModified(AttributeType at) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.attributeTypeModifiedFlatPresentation(at);
        } else if (presentation == 1) {
            this.attributeTypeModifiedHierarchicalPresentation(at);
        }
    }

    public void attributeTypeModifiedFlatPresentation(AttributeType at) {
    }

    public void attributeTypeModifiedHierarchicalPresentation(AttributeType at) {
        List<Object> parents;
        this.hierarchyManager.attributeTypeModified(at);
        List<TreeNode> wrappers = this.getWrappers(at);
        if (wrappers != null) {
            for (TreeNode wrapper : wrappers) {
                wrapper.getParent().removeChild(wrapper);
            }
            this.elementsToWrappersMap.remove((Object)at);
        }
        if ((parents = this.hierarchyManager.getParents(at)) != null) {
            for (Object parent : parents) {
                AttributeTypeWrapper parentATW = (AttributeTypeWrapper)this.getWrapper(parent);
                AttributeTypeWrapper atw = null;
                if (parentATW == null) {
                    int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                    if (group == 0) {
                        for (TreeNode child : this.root.getChildren()) {
                            Folder folder;
                            if (!(child instanceof Folder) || !(folder = (Folder)child).getType().equals((Object)Folder.FolderType.ATTRIBUTE_TYPE)) continue;
                            atw = new AttributeTypeWrapper(at, folder);
                            break;
                        }
                    } else if (group == 1) {
                        atw = new AttributeTypeWrapper(at, this.root);
                    }
                } else {
                    atw = new AttributeTypeWrapper(at, parentATW);
                }
                atw.getParent().addChild(atw);
                this.elementsToWrappersMap.put((Object)at, (Object)atw);
                this.addHierarchyChildren(atw, this.hierarchyManager.getChildren(at));
            }
        }
    }

    public void attributeTypeRemoved(AttributeType at) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.attributeTypeRemovedFlatPresentation(at);
        } else if (presentation == 1) {
            this.attributeTypeRemovedHierarchicalPresentation(at);
        }
    }

    private void attributeTypeRemovedFlatPresentation(AttributeType at) {
        AttributeTypeWrapper atw = (AttributeTypeWrapper)this.getWrapper(at);
        if (atw != null) {
            atw.getParent().removeChild(atw);
            this.elementsToWrappersMap.removeMapping((Object)at, (Object)atw);
        }
    }

    private void attributeTypeRemovedHierarchicalPresentation(AttributeType at) {
        List<TreeNode> wrappers;
        List<Object> children = this.hierarchyManager.getChildren(at);
        if (children != null) {
            for (Object child : children) {
                AbstractTreeNode atw = null;
                int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                if (group == 0) {
                    for (TreeNode rootChild : this.root.getChildren()) {
                        Folder folder;
                        if (!(rootChild instanceof Folder) || !(folder = (Folder)rootChild).getType().equals((Object)Folder.FolderType.ATTRIBUTE_TYPE)) continue;
                        atw = new AttributeTypeWrapper((AttributeType)child, folder);
                        break;
                    }
                } else if (group == 1) {
                    atw = new AttributeTypeWrapper((AttributeType)child, this.root);
                }
                atw.getParent().addChild(atw);
                this.elementsToWrappersMap.put(child, (Object)atw);
            }
        }
        if ((wrappers = this.getWrappers(at)) != null) {
            for (TreeNode wrapper : wrappers) {
                wrapper.getParent().removeChild(wrapper);
                this.removeRecursiveChildren(wrapper);
            }
            this.elementsToWrappersMap.remove((Object)at);
        }
        this.hierarchyManager.attributeTypeRemoved(at);
    }

    private void removeRecursiveChildren(TreeNode wrapper) {
        for (TreeNode child : wrapper.getChildren()) {
            if (child instanceof AttributeTypeWrapper) {
                AttributeTypeWrapper atw = (AttributeTypeWrapper)child;
                this.elementsToWrappersMap.removeMapping((Object)atw.getAttributeType(), (Object)child);
                this.removeRecursiveChildren(atw);
                continue;
            }
            if (child instanceof ObjectClassWrapper) {
                ObjectClassWrapper ocw = (ObjectClassWrapper)child;
                this.elementsToWrappersMap.removeMapping((Object)ocw.getObjectClass(), (Object)child);
                this.removeRecursiveChildren(ocw);
                continue;
            }
            this.removeRecursiveChildren(child);
        }
    }

    public void objectClassAdded(ObjectClass oc) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.objectClassAddedFlatPresentation(oc);
        } else if (presentation == 1) {
            this.objectClassAddedHierarchicalPresentation(oc);
        }
    }

    public void objectClassAddedFlatPresentation(ObjectClass oc) {
        SchemaWrapper schemaWrapper = (SchemaWrapper)this.getWrapper((Object)Activator.getDefault().getSchemaHandler().getSchema(oc.getSchemaName()));
        if (schemaWrapper != null) {
            AbstractTreeNode ocw = null;
            int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
            if (group == 0) {
                for (TreeNode child : schemaWrapper.getChildren()) {
                    if (((Folder)child).getType() != Folder.FolderType.OBJECT_CLASS) continue;
                    ocw = new ObjectClassWrapper(oc, child);
                    break;
                }
            } else if (group == 1) {
                ocw = new ObjectClassWrapper(oc, schemaWrapper);
            }
            ocw.getParent().addChild(ocw);
            this.elementsToWrappersMap.put((Object)oc, (Object)ocw);
        }
    }

    public void objectClassAddedHierarchicalPresentation(ObjectClass oc) {
        List<Object> list;
        ArrayList<Object> ocChildren = new ArrayList<Object>();
        List<Object> ocChildren2 = null;
        if ("2.5.6.0".equals(oc.getOid())) {
            ocChildren2 = this.hierarchyManager.getChildren("2.5.6.0");
            if (ocChildren2 != null) {
                ocChildren.addAll(ocChildren2);
            }
            if ((ocChildren2 = this.hierarchyManager.getChildren("top")) != null) {
                ocChildren.addAll(ocChildren2);
            }
        }
        if ((ocChildren2 = this.hierarchyManager.getChildren(oc)) != null) {
            ocChildren.addAll(ocChildren2);
        }
        for (Object e : ocChildren) {
            List<TreeNode> list2 = this.getWrappers(e);
            if (list2 == null) continue;
            for (TreeNode treeNode : list2) {
                int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                if (group == 0) {
                    if (treeNode.getParent().getParent().equals(this.root)) {
                        treeNode.getParent().removeChild(treeNode);
                        this.elementsToWrappersMap.removeMapping((Object)oc, (Object)treeNode);
                    }
                } else if (group == 1 && treeNode.getParent().equals(this.root)) {
                    treeNode.getParent().removeChild(treeNode);
                    this.elementsToWrappersMap.removeMapping((Object)oc, (Object)treeNode);
                }
                this.removeRecursiveChildren(treeNode);
            }
        }
        this.hierarchyManager.objectClassAdded(oc);
        ArrayList<ObjectClassWrapper> arrayList = new ArrayList<ObjectClassWrapper>();
        List<Object> parents = this.hierarchyManager.getParents(oc);
        if (parents != null) {
            for (Object object : parents) {
                ObjectClassWrapper parentOCW = (ObjectClassWrapper)this.getWrapper(object);
                ObjectClassWrapper ocw = null;
                if (parentOCW == null) {
                    int n = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                    if (n == 0) {
                        for (TreeNode child : this.root.getChildren()) {
                            Folder folder;
                            if (!(child instanceof Folder) || !(folder = (Folder)child).getType().equals((Object)Folder.FolderType.OBJECT_CLASS)) continue;
                            ocw = new ObjectClassWrapper(oc, folder);
                            break;
                        }
                    } else if (n == 1) {
                        ocw = new ObjectClassWrapper(oc, this.root);
                    }
                } else {
                    ocw = new ObjectClassWrapper(oc, parentOCW);
                }
                ocw.getParent().addChild(ocw);
                arrayList.add(ocw);
                this.elementsToWrappersMap.put((Object)oc, (Object)ocw);
            }
        }
        if ((list = this.hierarchyManager.getChildren(oc)) != null) {
            for (Object object : list) {
                List<TreeNode> childOCWs = this.getWrappers(object);
                if (childOCWs != null) {
                    for (TreeNode treeNode : childOCWs) {
                        if (!this.root.equals(treeNode.getParent())) continue;
                        this.elementsToWrappersMap.remove(object);
                        treeNode.getParent().removeChild(treeNode);
                    }
                }
                for (TreeNode treeNode : arrayList) {
                    ObjectClassWrapper ocw = new ObjectClassWrapper((ObjectClass)object, treeNode);
                    ocw.getParent().addChild(ocw);
                    this.elementsToWrappersMap.put(object, (Object)ocw);
                    this.addHierarchyChildren(ocw, this.hierarchyManager.getChildren(object));
                }
            }
        }
    }

    public void objectClassModified(ObjectClass oc) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.objectClassModifiedFlatPresentation(oc);
        } else if (presentation == 1) {
            this.objectClassModifiedHierarchicalPresentation(oc);
        }
    }

    public void objectClassModifiedFlatPresentation(ObjectClass oc) {
    }

    public void objectClassModifiedHierarchicalPresentation(ObjectClass oc) {
        List<Object> parents;
        this.hierarchyManager.objectClassModified(oc);
        List<TreeNode> wrappers = this.getWrappers(oc);
        if (wrappers != null) {
            for (TreeNode wrapper : wrappers) {
                wrapper.getParent().removeChild(wrapper);
            }
            this.elementsToWrappersMap.remove((Object)oc);
        }
        if ((parents = this.hierarchyManager.getParents(oc)) != null) {
            for (Object parent : parents) {
                ObjectClassWrapper parentOCW = (ObjectClassWrapper)this.getWrapper(parent);
                ObjectClassWrapper ocw = null;
                if (parentOCW == null) {
                    int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                    if (group == 0) {
                        for (TreeNode child : this.root.getChildren()) {
                            Folder folder;
                            if (!(child instanceof Folder) || !(folder = (Folder)child).getType().equals((Object)Folder.FolderType.OBJECT_CLASS)) continue;
                            ocw = new ObjectClassWrapper(oc, folder);
                            break;
                        }
                    } else if (group == 1) {
                        ocw = new ObjectClassWrapper(oc, this.root);
                    }
                } else {
                    ocw = new ObjectClassWrapper(oc, parentOCW);
                }
                ocw.getParent().addChild(ocw);
                this.elementsToWrappersMap.put((Object)oc, (Object)ocw);
                this.addHierarchyChildren(ocw, this.hierarchyManager.getChildren(oc));
            }
        }
    }

    public void objectClassRemoved(ObjectClass oc) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.objectClassRemovedFlatPresentation(oc);
        } else if (presentation == 1) {
            this.objectClassRemovedHierarchicalPresentation(oc);
        }
    }

    public void objectClassRemovedFlatPresentation(ObjectClass oc) {
        ObjectClassWrapper ocw = (ObjectClassWrapper)this.getWrapper(oc);
        if (ocw != null) {
            ocw.getParent().removeChild(ocw);
            this.elementsToWrappersMap.removeMapping((Object)oc, (Object)ocw);
        }
    }

    public void objectClassRemovedHierarchicalPresentation(ObjectClass oc) {
        List<TreeNode> wrappers;
        List<Object> children = this.hierarchyManager.getChildren(oc);
        if (children != null) {
            for (Object child : children) {
                AbstractTreeNode ocw = null;
                int group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                if (group == 0) {
                    for (TreeNode rootChild : this.root.getChildren()) {
                        Folder folder;
                        if (!(rootChild instanceof Folder) || !(folder = (Folder)rootChild).getType().equals((Object)Folder.FolderType.OBJECT_CLASS)) continue;
                        ocw = new ObjectClassWrapper((ObjectClass)child, folder);
                        break;
                    }
                } else if (group == 1) {
                    ocw = new ObjectClassWrapper((ObjectClass)child, this.root);
                }
                ocw.getParent().addChild(ocw);
                this.elementsToWrappersMap.put(child, (Object)ocw);
                this.addHierarchyChildren(ocw, this.hierarchyManager.getChildren(child));
            }
        }
        if ((wrappers = this.getWrappers(oc)) != null) {
            for (TreeNode wrapper : wrappers) {
                wrapper.getParent().removeChild(wrapper);
                this.removeRecursiveChildren(wrapper);
            }
            this.elementsToWrappersMap.remove((Object)oc);
        }
        this.hierarchyManager.objectClassRemoved(oc);
    }

    public void schemaAdded(Schema schema) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.schemaAddedFlatPresentation(schema);
        } else if (presentation == 1) {
            this.schemaAddedHierarchicalPresentation(schema);
        }
    }

    private void schemaAddedFlatPresentation(Schema schema) {
        this.addSchemaFlatPresentation(schema);
    }

    private void schemaAddedHierarchicalPresentation(Schema schema) {
        for (AttributeType at : schema.getAttributeTypes()) {
            this.attributeTypeAddedHierarchicalPresentation(at);
        }
        for (ObjectClass oc : schema.getObjectClasses()) {
            this.objectClassAddedHierarchicalPresentation(oc);
        }
    }

    public void schemaRemoved(Schema schema) {
        int presentation = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0) {
            this.schemaRemovedFlatPresentation(schema);
        } else if (presentation == 1) {
            this.schemaRemovedHierarchicalPresentation(schema);
        }
    }

    private void schemaRemovedFlatPresentation(Schema schema) {
        SchemaWrapper sw = (SchemaWrapper)this.getWrapper((Object)schema);
        if (sw != null) {
            sw.getParent().removeChild(sw);
            this.elementsToWrappersMap.removeMapping((Object)schema, (Object)sw);
            this.removeRecursiveChildren(sw);
        }
    }

    private void schemaRemovedHierarchicalPresentation(Schema schema) {
        for (AttributeType at : schema.getAttributeTypes()) {
            this.attributeTypeRemovedHierarchicalPresentation(at);
        }
        for (ObjectClass oc : schema.getObjectClasses()) {
            this.objectClassRemovedHierarchicalPresentation(oc);
        }
    }

    public void addSchemaFlatPresentation(Schema schema) {
        block5: {
            int group;
            SchemaWrapper schemaWrapper;
            block4: {
                schemaWrapper = new SchemaWrapper(schema, this.root);
                this.root.addChild(schemaWrapper);
                this.elementsToWrappersMap.put((Object)schema, (Object)schemaWrapper);
                group = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
                if (group != 0) break block4;
                Folder atFolder = new Folder(Folder.FolderType.ATTRIBUTE_TYPE, schemaWrapper);
                schemaWrapper.addChild(atFolder);
                for (AttributeType attributeType : schema.getAttributeTypes()) {
                    AttributeTypeWrapper atw = new AttributeTypeWrapper(attributeType, atFolder);
                    atw.getParent().addChild(atw);
                    this.elementsToWrappersMap.put((Object)attributeType, (Object)atw);
                }
                Folder ocFolder = new Folder(Folder.FolderType.OBJECT_CLASS, schemaWrapper);
                schemaWrapper.addChild(ocFolder);
                for (ObjectClass objectClass : schema.getObjectClasses()) {
                    ObjectClassWrapper ocw = new ObjectClassWrapper(objectClass, ocFolder);
                    ocw.getParent().addChild(ocw);
                    this.elementsToWrappersMap.put((Object)objectClass, (Object)ocw);
                }
                break block5;
            }
            if (group != 1) break block5;
            for (AttributeType attributeType : schema.getAttributeTypes()) {
                AttributeTypeWrapper atw = new AttributeTypeWrapper(attributeType, schemaWrapper);
                atw.getParent().addChild(atw);
                this.elementsToWrappersMap.put((Object)attributeType, (Object)atw);
            }
            for (ObjectClass objectClass : schema.getObjectClasses()) {
                ObjectClassWrapper ocw = new ObjectClassWrapper(objectClass, schemaWrapper);
                ocw.getParent().addChild(ocw);
                this.elementsToWrappersMap.put((Object)objectClass, (Object)ocw);
            }
        }
    }
}

