/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.resourcemanager.compute.fluent.VirtualMachineExtensionsClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.implementation.VirtualMachineExtensionImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineImpl;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineExtension;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class VirtualMachineExtensionsImpl
extends ExternalChildResourcesCachedImpl<VirtualMachineExtensionImpl, VirtualMachineExtension, VirtualMachineExtensionInner, VirtualMachineImpl, VirtualMachine> {
    private final VirtualMachineExtensionsClient client;

    VirtualMachineExtensionsImpl(VirtualMachineExtensionsClient client, VirtualMachineImpl parent) {
        super((Object)parent, parent.taskGroup(), "VirtualMachineExtension");
        this.client = client;
        this.cacheCollection();
    }

    public Map<String, VirtualMachineExtension> asMap() {
        return (Map)this.asMapAsync().block();
    }

    public Mono<Map<String, VirtualMachineExtension>> asMapAsync() {
        return this.listAsync().flatMapMany(Flux::fromIterable).collect(Collectors.toMap(extension -> extension.name(), extension -> extension)).map(map -> Collections.unmodifiableMap(map));
    }

    public Mono<List<VirtualMachineExtension>> listAsync() {
        Flux extensions = Flux.fromIterable(this.collection().values());
        Flux resolvedExtensionsStream = extensions.filter(extension -> extension.isReference()).flatMap(extension -> this.client.getAsync(((VirtualMachineImpl)this.getParent()).resourceGroupName(), ((VirtualMachineImpl)this.getParent()).name(), extension.name()).map(extensionInner -> new VirtualMachineExtensionImpl(extension.name(), (VirtualMachineImpl)this.getParent(), (VirtualMachineExtensionInner)((Object)((Object)extensionInner)), this.client)));
        return resolvedExtensionsStream.concatWith((Publisher)extensions.filter(extension -> !extension.isReference())).collectList().map(list -> Collections.unmodifiableList(list));
    }

    public VirtualMachineExtensionImpl define(String name) {
        VirtualMachineExtensionImpl newExtension = (VirtualMachineExtensionImpl)this.prepareInlineDefine(name);
        return newExtension;
    }

    public VirtualMachineExtensionImpl update(String name) {
        return (VirtualMachineExtensionImpl)this.prepareInlineUpdate(name);
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addExtension(VirtualMachineExtensionImpl extension) {
        this.addChildResource(extension);
    }

    protected List<VirtualMachineExtensionImpl> listChildResources() {
        ArrayList<VirtualMachineExtensionImpl> childResources = new ArrayList<VirtualMachineExtensionImpl>();
        if (((VirtualMachineInner)((Object)((VirtualMachineImpl)this.getParent()).innerModel())).resources() != null) {
            for (VirtualMachineExtensionInner inner : ((VirtualMachineInner)((Object)((VirtualMachineImpl)this.getParent()).innerModel())).resources()) {
                if (inner.name() == null) {
                    inner.withLocation(((VirtualMachineImpl)this.getParent()).regionName());
                    childResources.add(new VirtualMachineExtensionImpl(ResourceUtils.nameFromResourceId((String)inner.id()), (VirtualMachineImpl)this.getParent(), inner, this.client));
                    continue;
                }
                childResources.add(new VirtualMachineExtensionImpl(inner.name(), (VirtualMachineImpl)this.getParent(), inner, this.client));
            }
        }
        return Collections.unmodifiableList(childResources);
    }

    protected Flux<VirtualMachineExtensionImpl> listChildResourcesAsync() {
        return Flux.fromIterable(this.listChildResources());
    }

    protected VirtualMachineExtensionImpl newChildResource(String name) {
        VirtualMachineExtensionImpl extension = VirtualMachineExtensionImpl.newVirtualMachineExtension(name, (VirtualMachineImpl)this.getParent(), this.client);
        return extension;
    }
}

