/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.dolphinscheduler.common.constants.SystemConstants;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true)).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true)).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true)).addModule((Module)new SimpleModule().addSerializer(LocalDateTime.class, (com.fasterxml.jackson.databind.JsonSerializer)new JSONUtils.LocalDateTimeSerializer()).addDeserializer(LocalDateTime.class, (JsonDeserializer)new JSONUtils.LocalDateTimeDeserializer()))).defaultTimeZone(SystemConstants.DEFAULT_TIME_ZONE)).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"))).build();

    private JsonSerializer() {
    }

    public static <T> byte[] serialize(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj).getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            log.error("serializeToString exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T deserialize(byte[] src, Class<T> clazz) {
        if (src == null) {
            return null;
        }
        String json = new String(src, StandardCharsets.UTF_8);
        return (T)objectMapper.readValue(json, clazz);
    }
}

