/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.")
public class V1ISCSIPersistentVolumeSource {
    public static final String SERIALIZED_NAME_CHAP_AUTH_DISCOVERY = "chapAuthDiscovery";
    @SerializedName(value="chapAuthDiscovery")
    private Boolean chapAuthDiscovery;
    public static final String SERIALIZED_NAME_CHAP_AUTH_SESSION = "chapAuthSession";
    @SerializedName(value="chapAuthSession")
    private Boolean chapAuthSession;
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_INITIATOR_NAME = "initiatorName";
    @SerializedName(value="initiatorName")
    private String initiatorName;
    public static final String SERIALIZED_NAME_IQN = "iqn";
    @SerializedName(value="iqn")
    private String iqn;
    public static final String SERIALIZED_NAME_ISCSI_INTERFACE = "iscsiInterface";
    @SerializedName(value="iscsiInterface")
    private String iscsiInterface;
    public static final String SERIALIZED_NAME_LUN = "lun";
    @SerializedName(value="lun")
    private Integer lun;
    public static final String SERIALIZED_NAME_PORTALS = "portals";
    @SerializedName(value="portals")
    private List<String> portals = null;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1SecretReference secretRef;
    public static final String SERIALIZED_NAME_TARGET_PORTAL = "targetPortal";
    @SerializedName(value="targetPortal")
    private String targetPortal;

    public V1ISCSIPersistentVolumeSource chapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="whether support iSCSI Discovery CHAP authentication")
    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    public void setChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
    }

    public V1ISCSIPersistentVolumeSource chapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="whether support iSCSI Session CHAP authentication")
    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    public void setChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
    }

    public V1ISCSIPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1ISCSIPersistentVolumeSource initiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.")
    public String getInitiatorName() {
        return this.initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public V1ISCSIPersistentVolumeSource iqn(String iqn) {
        this.iqn = iqn;
        return this;
    }

    @ApiModelProperty(required=true, value="Target iSCSI Qualified Name.")
    public String getIqn() {
        return this.iqn;
    }

    public void setIqn(String iqn) {
        this.iqn = iqn;
    }

    public V1ISCSIPersistentVolumeSource iscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).")
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    public void setIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
    }

    public V1ISCSIPersistentVolumeSource lun(Integer lun) {
        this.lun = lun;
        return this;
    }

    @ApiModelProperty(required=true, value="iSCSI Target Lun number.")
    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public V1ISCSIPersistentVolumeSource portals(List<String> portals) {
        this.portals = portals;
        return this;
    }

    public V1ISCSIPersistentVolumeSource addPortalsItem(String portalsItem) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(portalsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    public List<String> getPortals() {
        return this.portals;
    }

    public void setPortals(List<String> portals) {
        this.portals = portals;
    }

    public V1ISCSIPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1ISCSIPersistentVolumeSource secretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1ISCSIPersistentVolumeSource targetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return this;
    }

    @ApiModelProperty(required=true, value="iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    public String getTargetPortal() {
        return this.targetPortal;
    }

    public void setTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ISCSIPersistentVolumeSource v1ISCSIPersistentVolumeSource = (V1ISCSIPersistentVolumeSource)o;
        return Objects.equals(this.chapAuthDiscovery, v1ISCSIPersistentVolumeSource.chapAuthDiscovery) && Objects.equals(this.chapAuthSession, v1ISCSIPersistentVolumeSource.chapAuthSession) && Objects.equals(this.fsType, v1ISCSIPersistentVolumeSource.fsType) && Objects.equals(this.initiatorName, v1ISCSIPersistentVolumeSource.initiatorName) && Objects.equals(this.iqn, v1ISCSIPersistentVolumeSource.iqn) && Objects.equals(this.iscsiInterface, v1ISCSIPersistentVolumeSource.iscsiInterface) && Objects.equals(this.lun, v1ISCSIPersistentVolumeSource.lun) && Objects.equals(this.portals, v1ISCSIPersistentVolumeSource.portals) && Objects.equals(this.readOnly, v1ISCSIPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, v1ISCSIPersistentVolumeSource.secretRef) && Objects.equals(this.targetPortal, v1ISCSIPersistentVolumeSource.targetPortal);
    }

    public int hashCode() {
        return Objects.hash(this.chapAuthDiscovery, this.chapAuthSession, this.fsType, this.initiatorName, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.secretRef, this.targetPortal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ISCSIPersistentVolumeSource {\n");
        sb.append("    chapAuthDiscovery: ").append(this.toIndentedString(this.chapAuthDiscovery)).append("\n");
        sb.append("    chapAuthSession: ").append(this.toIndentedString(this.chapAuthSession)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    initiatorName: ").append(this.toIndentedString(this.initiatorName)).append("\n");
        sb.append("    iqn: ").append(this.toIndentedString(this.iqn)).append("\n");
        sb.append("    iscsiInterface: ").append(this.toIndentedString(this.iscsiInterface)).append("\n");
        sb.append("    lun: ").append(this.toIndentedString(this.lun)).append("\n");
        sb.append("    portals: ").append(this.toIndentedString(this.portals)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    targetPortal: ").append(this.toIndentedString(this.targetPortal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

