/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryThreadFactory;
import org.apache.dolphinscheduler.plugin.registry.jdbc.KeyUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataChanceEventDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryDataChanceEventRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryDataRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IJdbcRegistryDataManager;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IRegistryRowChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRegistryDataManager
implements IRegistryRowChangeNotifier<JdbcRegistryDataDTO>,
IJdbcRegistryDataManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistryDataManager.class);
    private final Integer keepJdbcRegistryDataChanceEventHours = 2;
    private final JdbcRegistryProperties registryProperties;
    private final JdbcRegistryDataRepository jdbcRegistryDataRepository;
    private final JdbcRegistryDataChanceEventRepository jdbcRegistryDataChanceEventRepository;
    private final List<IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>> registryRowChangeListeners;
    private long lastDetectedJdbcRegistryDataChangeEventId = -1L;

    public JdbcRegistryDataManager(JdbcRegistryProperties registryProperties, JdbcRegistryDataRepository jdbcRegistryDataRepository, JdbcRegistryDataChanceEventRepository jdbcRegistryDataChanceEventRepository) {
        this.registryProperties = registryProperties;
        this.jdbcRegistryDataChanceEventRepository = jdbcRegistryDataChanceEventRepository;
        this.jdbcRegistryDataRepository = jdbcRegistryDataRepository;
        this.registryRowChangeListeners = new CopyOnWriteArrayList<IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>>();
        this.lastDetectedJdbcRegistryDataChangeEventId = jdbcRegistryDataChanceEventRepository.getMaxJdbcRegistryDataChanceEventId();
    }

    @Override
    public void start() {
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::detectJdbcRegistryDataChangeEvent, this.registryProperties.getHeartbeatRefreshInterval().toMillis(), this.registryProperties.getHeartbeatRefreshInterval().toMillis(), TimeUnit.MILLISECONDS);
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::purgeHistoryJdbcRegistryDataChangeEvent, 0L, Duration.ofHours(this.keepJdbcRegistryDataChanceEventHours.intValue()).toHours(), TimeUnit.HOURS);
    }

    private void detectJdbcRegistryDataChangeEvent() {
        List<JdbcRegistryDataChanceEventDTO> jdbcRegistryDataChanceEvents = this.jdbcRegistryDataChanceEventRepository.selectJdbcRegistryDataChangeEventWhereIdAfter(this.lastDetectedJdbcRegistryDataChangeEventId);
        if (CollectionUtils.isEmpty(jdbcRegistryDataChanceEvents)) {
            return;
        }
        for (JdbcRegistryDataChanceEventDTO jdbcRegistryDataChanceEvent : jdbcRegistryDataChanceEvents) {
            log.debug("Detect JdbcRegistryDataChangeEvent: {}", (Object)jdbcRegistryDataChanceEvent);
            switch (jdbcRegistryDataChanceEvent.getEventType()) {
                case ADD: {
                    this.doTriggerJdbcRegistryDataAddedListener(Lists.newArrayList((Object[])new JdbcRegistryDataDTO[]{jdbcRegistryDataChanceEvent.getJdbcRegistryData()}));
                    break;
                }
                case UPDATE: {
                    this.doTriggerJdbcRegistryDataUpdatedListener(Lists.newArrayList((Object[])new JdbcRegistryDataDTO[]{jdbcRegistryDataChanceEvent.getJdbcRegistryData()}));
                    break;
                }
                case DELETE: {
                    this.doTriggerJdbcRegistryDataRemovedListener(Lists.newArrayList((Object[])new JdbcRegistryDataDTO[]{jdbcRegistryDataChanceEvent.getJdbcRegistryData()}));
                    break;
                }
                default: {
                    log.error("Unknown event type: {}", (Object)jdbcRegistryDataChanceEvent.getEventType());
                }
            }
            if (jdbcRegistryDataChanceEvent.getId() <= this.lastDetectedJdbcRegistryDataChangeEventId) continue;
            this.lastDetectedJdbcRegistryDataChangeEventId = jdbcRegistryDataChanceEvent.getId();
        }
    }

    private void purgeHistoryJdbcRegistryDataChangeEvent() {
        log.info("Purge JdbcRegistryDataChanceEvent which createTime is before: {} hours", (Object)this.keepJdbcRegistryDataChanceEventHours);
        this.jdbcRegistryDataChanceEventRepository.deleteJdbcRegistryDataChangeEventBeforeCreateTime(DateUtils.addHours((Date)new Date(), (int)(-this.keepJdbcRegistryDataChanceEventHours.intValue())));
    }

    @Override
    public void subscribeRegistryRowChange(IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO> registryRowChangeListener) {
        this.registryRowChangeListeners.add((IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>)Preconditions.checkNotNull(registryRowChangeListener));
    }

    @Override
    public boolean existKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.jdbcRegistryDataRepository.selectByKey(key).isPresent();
    }

    @Override
    public List<JdbcRegistryDataDTO> getAllJdbcRegistryData() {
        return this.jdbcRegistryDataRepository.selectAll();
    }

    @Override
    public Optional<JdbcRegistryDataDTO> getRegistryDataByKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.jdbcRegistryDataRepository.selectByKey(key);
    }

    @Override
    public List<JdbcRegistryDataDTO> listJdbcRegistryDataChildren(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.jdbcRegistryDataRepository.selectAll().stream().filter(jdbcRegistryDataDTO -> KeyUtils.isParent(key, jdbcRegistryDataDTO.getDataKey())).collect(Collectors.toList());
    }

    @Override
    public void putJdbcRegistryData(Long clientId, String key, String value, DataType dataType) {
        Preconditions.checkNotNull((Object)clientId);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)((Object)dataType));
        Optional<JdbcRegistryDataDTO> jdbcRegistryDataOptional = this.jdbcRegistryDataRepository.selectByKey(key);
        if (jdbcRegistryDataOptional.isPresent()) {
            JdbcRegistryDataDTO jdbcRegistryData = jdbcRegistryDataOptional.get();
            if (!dataType.name().equals(jdbcRegistryData.getDataType())) {
                throw new UnsupportedOperationException("The data type: " + jdbcRegistryData.getDataType() + " of the key: " + key + " cannot be updated");
            }
            if (DataType.EPHEMERAL.name().equals(jdbcRegistryData.getDataType()) && !jdbcRegistryData.getClientId().equals(clientId)) {
                throw new UnsupportedOperationException("The EPHEMERAL data: " + key + " can only be updated by its owner: " + jdbcRegistryData.getClientId() + " but not: " + clientId);
            }
            jdbcRegistryData.setDataValue(value);
            jdbcRegistryData.setLastUpdateTime(new Date());
            this.jdbcRegistryDataRepository.updateById(jdbcRegistryData);
            JdbcRegistryDataChanceEventDTO jdbcRegistryDataChanceEvent = JdbcRegistryDataChanceEventDTO.builder().jdbcRegistryData(jdbcRegistryData).eventType(JdbcRegistryDataChanceEventDTO.EventType.UPDATE).createTime(new Date()).build();
            this.jdbcRegistryDataChanceEventRepository.insert(jdbcRegistryDataChanceEvent);
        } else {
            JdbcRegistryDataDTO jdbcRegistryDataDTO = JdbcRegistryDataDTO.builder().clientId(clientId).dataKey(key).dataValue(value).dataType(dataType.name()).createTime(new Date()).lastUpdateTime(new Date()).build();
            this.jdbcRegistryDataRepository.insert(jdbcRegistryDataDTO);
            JdbcRegistryDataChanceEventDTO registryDataChanceEvent = JdbcRegistryDataChanceEventDTO.builder().jdbcRegistryData(jdbcRegistryDataDTO).eventType(JdbcRegistryDataChanceEventDTO.EventType.ADD).createTime(new Date()).build();
            this.jdbcRegistryDataChanceEventRepository.insert(registryDataChanceEvent);
        }
    }

    @Override
    public void deleteJdbcRegistryDataByKey(String key) {
        Preconditions.checkNotNull((Object)key);
        Optional<JdbcRegistryDataDTO> jdbcRegistryDataOptional = this.jdbcRegistryDataRepository.selectByKey(key);
        if (!jdbcRegistryDataOptional.isPresent()) {
            return;
        }
        this.jdbcRegistryDataRepository.deleteByKey(key);
        JdbcRegistryDataChanceEventDTO registryDataChanceEvent = JdbcRegistryDataChanceEventDTO.builder().jdbcRegistryData(jdbcRegistryDataOptional.get()).eventType(JdbcRegistryDataChanceEventDTO.EventType.DELETE).createTime(new Date()).build();
        this.jdbcRegistryDataChanceEventRepository.insert(registryDataChanceEvent);
    }

    private void doTriggerJdbcRegistryDataAddedListener(List<JdbcRegistryDataDTO> valuesToAdd) {
        if (CollectionUtils.isEmpty(valuesToAdd)) {
            return;
        }
        log.debug("Trigger:onJdbcRegistryDataAdded: {}", valuesToAdd);
        valuesToAdd.forEach(jdbcRegistryData -> {
            try {
                this.registryRowChangeListeners.forEach(listener -> listener.onRegistryRowAdded(jdbcRegistryData));
            }
            catch (Exception ex) {
                log.error("Trigger:onRegistryRowAdded: {} failed", jdbcRegistryData, (Object)ex);
            }
        });
    }

    private void doTriggerJdbcRegistryDataRemovedListener(List<JdbcRegistryDataDTO> valuesToRemoved) {
        if (CollectionUtils.isEmpty(valuesToRemoved)) {
            return;
        }
        log.debug("Trigger:onJdbcRegistryDataDeleted: {}", valuesToRemoved);
        valuesToRemoved.forEach(jdbcRegistryData -> {
            try {
                this.registryRowChangeListeners.forEach(listener -> listener.onRegistryRowDeleted(jdbcRegistryData));
            }
            catch (Exception ex) {
                log.error("Trigger:onRegistryRowAdded: {} failed", jdbcRegistryData, (Object)ex);
            }
        });
    }

    private void doTriggerJdbcRegistryDataUpdatedListener(List<JdbcRegistryDataDTO> valuesToUpdated) {
        if (CollectionUtils.isEmpty(valuesToUpdated)) {
            return;
        }
        log.debug("Trigger:onJdbcRegistryDataUpdated: {}", valuesToUpdated);
        valuesToUpdated.forEach(jdbcRegistryData -> {
            try {
                this.registryRowChangeListeners.forEach(listener -> listener.onRegistryRowUpdated(jdbcRegistryData));
            }
            catch (Exception ex) {
                log.error("Trigger:onRegistryRowAdded: {} failed", jdbcRegistryData, (Object)ex);
            }
        });
    }
}

