/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.extract.base.metrics.ClientSyncDurationMetrics;
import org.apache.dolphinscheduler.extract.base.metrics.ClientSyncExceptionMetrics;
import org.apache.dolphinscheduler.extract.base.protocal.Transporter;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterHeader;

public class RpcMetrics {
    private static final Map<String, Timer> rpcRequestDurationTimer = new ConcurrentHashMap<String, Timer>();
    private static final Map<String, Counter> rpcRequestExceptionCounter = new ConcurrentHashMap<String, Counter>();

    public static void recordClientSyncRequestException(ClientSyncExceptionMetrics clientSyncExceptionMetrics) {
        RpcMetrics.recordClientSyncRequestException(clientSyncExceptionMetrics.getThrowable(), Optional.of(clientSyncExceptionMetrics).map(ClientSyncExceptionMetrics::getTransporter).map(Transporter::getHeader).map(TransporterHeader::getMethodIdentifier).orElse("unknown"), clientSyncExceptionMetrics.getClientHost(), clientSyncExceptionMetrics.getServerAddress());
    }

    public static void recordClientSyncRequestException(Throwable throwable, String methodName, String clientHost, String serverHost) {
        String exceptionType = throwable == null ? "unknown" : throwable.getClass().getSimpleName();
        Counter counter = rpcRequestExceptionCounter.computeIfAbsent(exceptionType, et -> Counter.builder((String)"ds.rpc.client.sync.request.exception.count").tag("method_name", methodName).tag("client_host", clientHost).tag("server_host", serverHost).tag("exception_name", et).description("rpc sync request exception counter for exception type: " + et).register((MeterRegistry)Metrics.globalRegistry));
        counter.increment();
    }

    public static void recordClientSyncRequestDuration(ClientSyncDurationMetrics clientSyncDurationMetrics) {
        RpcMetrics.recordClientSyncRequestDuration(Optional.of(clientSyncDurationMetrics).map(ClientSyncDurationMetrics::getTransporter).map(Transporter::getHeader).map(TransporterHeader::getMethodIdentifier).orElseGet(() -> "unknown"), clientSyncDurationMetrics.getMilliseconds(), clientSyncDurationMetrics.getClientHost(), clientSyncDurationMetrics.getServerHost());
    }

    public static void recordClientSyncRequestDuration(String methodName, long milliseconds, String clientHost, String serverHost) {
        rpcRequestDurationTimer.computeIfAbsent(methodName, method -> Timer.builder((String)"ds.rpc.client.sync.request.duration.time").tag("method_name", method).tag("client_host", clientHost).tag("server_host", serverHost).publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).publishPercentileHistogram().description("time cost of sync rpc request, unit ms").register((MeterRegistry)Metrics.globalRegistry)).record(milliseconds, TimeUnit.MILLISECONDS);
    }
}

