/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksResponse;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.AbstractWorkflowInstanceTrigger;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceRecoverSuspendTaskTrigger
extends AbstractWorkflowInstanceTrigger<WorkflowInstanceRecoverSuspendTasksRequest, WorkflowInstanceRecoverSuspendTasksResponse> {
    @Override
    protected WorkflowInstance constructWorkflowInstance(WorkflowInstanceRecoverSuspendTasksRequest workflowInstanceRecoverSuspendTasksRequest) {
        WorkflowInstance workflowInstance = this.getWorkflowInstance(workflowInstanceRecoverSuspendTasksRequest.getWorkflowInstanceId());
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUBMITTED_SUCCESS, CommandType.START_FAILURE_TASK_PROCESS.name());
        workflowInstance.setRunTimes(workflowInstance.getRunTimes() + 1);
        workflowInstance.setRestartTime(new Date());
        workflowInstance.setEndTime(null);
        return workflowInstance;
    }

    @Override
    protected Command constructTriggerCommand(WorkflowInstanceRecoverSuspendTasksRequest workflowInstanceRecoverSuspendTasksRequest, WorkflowInstance workflowInstance) {
        return Command.builder().commandType(CommandType.RECOVER_SUSPENDED_PROCESS).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode().longValue()).workflowDefinitionVersion(workflowInstance.getWorkflowDefinitionVersion()).workflowInstanceId(workflowInstance.getId().intValue()).executorId(workflowInstanceRecoverSuspendTasksRequest.getUserId().intValue()).startTime(new Date()).updateTime(new Date()).build();
    }

    @Override
    protected WorkflowInstanceRecoverSuspendTasksResponse onTriggerSuccess(WorkflowInstance workflowInstance) {
        return WorkflowInstanceRecoverSuspendTasksResponse.success();
    }
}

