/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command.handler;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.command.handler.AbstractCommandHandler;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.WorkflowGraphTopologyLogicalVisitor;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskExecutionRunnableBuilder;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.TaskInstanceFactories;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RecoverFailureTaskCommandHandler
extends AbstractCommandHandler {
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TaskInstanceFactories taskInstanceFactories;
    @Autowired
    private MasterConfig masterConfig;

    @Override
    protected void assembleWorkflowInstance(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        Command command = workflowExecuteContextBuilder.getCommand();
        int workflowInstanceId = command.getWorkflowInstanceId();
        WorkflowInstance workflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryOptionalById((Serializable)Integer.valueOf(workflowInstanceId)).orElseThrow(() -> new IllegalArgumentException("Cannot find WorkflowInstance:" + workflowInstanceId));
        workflowInstance.setVarPool(null);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.RUNNING_EXECUTION, command.getCommandType().name());
        workflowInstance.setCommandType(command.getCommandType());
        workflowInstance.setHost(this.masterConfig.getMasterAddress());
        this.workflowInstanceDao.updateById((Object)workflowInstance);
        workflowExecuteContextBuilder.setWorkflowInstance(workflowInstance);
    }

    @Override
    protected void assembleWorkflowExecutionGraph(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        Map taskInstanceMap = this.dealWithHistoryTaskInstances(workflowExecuteContextBuilder).stream().collect(Collectors.toMap(TaskInstance::getName, Function.identity()));
        IWorkflowGraph workflowGraph = workflowExecuteContextBuilder.getWorkflowGraph();
        WorkflowExecutionGraph workflowExecutionGraph = new WorkflowExecutionGraph();
        BiConsumer<String, Set<String>> taskExecutionRunnableCreator = (task, successors) -> {
            TaskExecutionRunnableBuilder taskExecutionRunnableBuilder = TaskExecutionRunnableBuilder.builder().workflowExecutionGraph(workflowExecutionGraph).workflowDefinition(workflowExecuteContextBuilder.getWorkflowDefinition()).project(workflowExecuteContextBuilder.getProject()).workflowInstance(workflowExecuteContextBuilder.getWorkflowInstance()).taskDefinition(workflowGraph.getTaskNodeByName((String)task)).taskInstance((TaskInstance)taskInstanceMap.get(task)).workflowEventBus(workflowExecuteContextBuilder.getWorkflowEventBus()).applicationContext(this.applicationContext).build();
            workflowExecutionGraph.addNode(new TaskExecutionRunnable(taskExecutionRunnableBuilder));
            workflowExecutionGraph.addEdge((String)task, (Set<String>)successors);
        };
        WorkflowGraphTopologyLogicalVisitor workflowGraphTopologyLogicalVisitor = WorkflowGraphTopologyLogicalVisitor.builder().taskDependType(workflowExecuteContextBuilder.getWorkflowInstance().getTaskDependType()).onWorkflowGraph(workflowGraph).fromTask(this.parseStartNodesFromWorkflowInstance(workflowExecuteContextBuilder)).doVisitFunction(taskExecutionRunnableCreator).build();
        workflowGraphTopologyLogicalVisitor.visit();
        workflowExecutionGraph.removeUnReachableEdge();
        workflowExecuteContextBuilder.setWorkflowExecutionGraph(workflowExecutionGraph);
    }

    private List<TaskInstance> dealWithHistoryTaskInstances(WorkflowExecuteContext.WorkflowExecuteContextBuilder workflowExecuteContextBuilder) {
        WorkflowInstance workflowInstance = workflowExecuteContextBuilder.getWorkflowInstance();
        Map taskInstanceMap = super.getValidTaskInstance(workflowInstance).stream().collect(Collectors.toMap(TaskInstance::getName, Function.identity()));
        IWorkflowGraph workflowGraph = workflowExecuteContextBuilder.getWorkflowGraph();
        HashSet needRecoverTasks = new HashSet();
        HashSet markInvalidTasks = new HashSet();
        BiConsumer<String, Set<String>> historyTaskInstanceMarker = (task, successors) -> {
            if (markInvalidTasks.contains(task)) {
                if (taskInstanceMap.containsKey(task)) {
                    this.taskInstanceDao.markTaskInstanceInvalid((List)Lists.newArrayList((Object[])new TaskInstance[]{(TaskInstance)taskInstanceMap.get(task)}));
                    taskInstanceMap.remove(task);
                }
                markInvalidTasks.addAll(successors);
                return;
            }
            TaskInstance taskInstance = (TaskInstance)taskInstanceMap.get(task);
            if (taskInstance == null) {
                return;
            }
            if (this.isTaskNeedRecreate(taskInstance) || this.isTaskCanRecover(taskInstance)) {
                needRecoverTasks.add(task);
                markInvalidTasks.addAll(successors);
            }
        };
        WorkflowGraphTopologyLogicalVisitor workflowGraphTopologyLogicalVisitor = WorkflowGraphTopologyLogicalVisitor.builder().onWorkflowGraph(workflowGraph).taskDependType(workflowInstance.getTaskDependType()).fromTask(this.parseStartNodesFromWorkflowInstance(workflowExecuteContextBuilder)).doVisitFunction(historyTaskInstanceMarker).build();
        workflowGraphTopologyLogicalVisitor.visit();
        for (String task2 : needRecoverTasks) {
            TaskInstance taskInstance = (TaskInstance)taskInstanceMap.get(task2);
            if (this.isTaskCanRecover(taskInstance)) {
                taskInstanceMap.put(task2, this.createRecoverTaskInstance(taskInstance));
                continue;
            }
            if (!this.isTaskNeedRecreate(taskInstance)) continue;
            taskInstanceMap.put(task2, this.createRecreatedTaskInstance(taskInstance));
        }
        return new ArrayList<TaskInstance>(taskInstanceMap.values());
    }

    private boolean isTaskNeedRecreate(TaskInstance taskInstance) {
        if (taskInstance == null) {
            return false;
        }
        return taskInstance.getState() == TaskExecutionStatus.FAILURE || taskInstance.getState() == TaskExecutionStatus.KILL;
    }

    private TaskInstance createRecreatedTaskInstance(TaskInstance taskInstance) {
        return this.taskInstanceFactories.failedRecoverTaskInstanceFactory().builder().withTaskInstance(taskInstance).build();
    }

    private boolean isTaskCanRecover(TaskInstance taskInstance) {
        if (taskInstance == null) {
            return false;
        }
        return taskInstance.getState() == TaskExecutionStatus.PAUSE;
    }

    private TaskInstance createRecoverTaskInstance(TaskInstance taskInstance) {
        return this.taskInstanceFactories.pauseRecoverTaskInstanceFactory().builder().withTaskInstance(taskInstance).build();
    }

    @Override
    public CommandType commandType() {
        return CommandType.START_FAILURE_TASK_PROCESS;
    }
}

