/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ILogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ILogicTaskPluginFactory;
import org.apache.dolphinscheduler.server.master.exception.LogicTaskFactoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogicTaskPluginFactoryBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicTaskPluginFactoryBuilder.class);
    private final Map<String, ILogicTaskPluginFactory<? extends ILogicTask<? extends AbstractParameters>>> logicTaskPluginFactoryMap = new ConcurrentHashMap<String, ILogicTaskPluginFactory<? extends ILogicTask<? extends AbstractParameters>>>();

    public LogicTaskPluginFactoryBuilder(List<ILogicTaskPluginFactory<? extends ILogicTask<? extends AbstractParameters>>> logicTaskPluginFactories) {
        logicTaskPluginFactories.forEach(logicTaskPluginFactory -> this.logicTaskPluginFactoryMap.put(logicTaskPluginFactory.getTaskType(), (ILogicTaskPluginFactory<? extends ILogicTask<? extends AbstractParameters>>)logicTaskPluginFactory));
    }

    public ILogicTaskPluginFactory<? extends ILogicTask<? extends AbstractParameters>> createILogicTaskPluginFactory(String taskType) throws LogicTaskFactoryNotFoundException {
        ILogicTaskPluginFactory<? extends ILogicTask<? extends AbstractParameters>> logicTaskPluginFactory = this.logicTaskPluginFactoryMap.get(taskType);
        if (logicTaskPluginFactory == null) {
            throw new LogicTaskFactoryNotFoundException("Cannot find the logic task factory: " + taskType);
        }
        return logicTaskPluginFactory;
    }
}

