/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.security.AuthenticationType;
import org.apache.dolphinscheduler.api.security.Authenticator;
import org.apache.dolphinscheduler.api.security.impl.AbstractAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.ldap.LdapAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.pwd.PasswordAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.sso.CasdoorAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SecurityConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    @Value(value="${security.authentication.type:PASSWORD}")
    private String type;
    private AutowireCapableBeanFactory beanFactory;
    private AuthenticationType authenticationType;

    @Autowired
    public SecurityConfig(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private void setAuthenticationType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            log.info("security.authentication.type configuration is empty, the default value 'PASSWORD'");
            this.authenticationType = AuthenticationType.PASSWORD;
            return;
        }
        this.authenticationType = AuthenticationType.valueOf(type);
    }

    @Bean(name={"authenticator"})
    public Authenticator authenticator() {
        AbstractAuthenticator authenticator;
        this.setAuthenticationType(this.type);
        switch (this.authenticationType) {
            case PASSWORD: {
                authenticator = new PasswordAuthenticator();
                break;
            }
            case LDAP: {
                authenticator = new LdapAuthenticator();
                break;
            }
            case CASDOOR_SSO: {
                authenticator = new CasdoorAuthenticator();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.authenticationType));
            }
        }
        this.beanFactory.autowireBean((Object)authenticator);
        return authenticator;
    }

    public String getType() {
        return this.type;
    }
}

