/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.util;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.implementation.models.ArrowConfiguration;
import com.azure.storage.blob.implementation.models.ArrowField;
import com.azure.storage.blob.implementation.models.DelimitedTextConfiguration;
import com.azure.storage.blob.implementation.models.JsonTextConfiguration;
import com.azure.storage.blob.implementation.models.QueryFormat;
import com.azure.storage.blob.implementation.models.QueryFormatType;
import com.azure.storage.blob.implementation.models.QuerySerialization;
import com.azure.storage.blob.models.BlobQueryArrowField;
import com.azure.storage.blob.models.BlobQueryArrowSerialization;
import com.azure.storage.blob.models.BlobQueryDelimitedSerialization;
import com.azure.storage.blob.models.BlobQueryError;
import com.azure.storage.blob.models.BlobQueryJsonSerialization;
import com.azure.storage.blob.models.BlobQueryParquetSerialization;
import com.azure.storage.blob.models.BlobQueryProgress;
import com.azure.storage.blob.models.BlobQuerySerialization;
import com.azure.storage.internal.avro.implementation.AvroObject;
import com.azure.storage.internal.avro.implementation.AvroReaderFactory;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.azure.storage.internal.avro.implementation.schema.primitive.AvroNullSchema;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobQueryReader {
    private final Flux<ByteBuffer> avro;
    private final Consumer<BlobQueryProgress> progressConsumer;
    private final Consumer<BlobQueryError> errorConsumer;

    public BlobQueryReader(Flux<ByteBuffer> avro, Consumer<BlobQueryProgress> progressConsumer, Consumer<BlobQueryError> errorConsumer) {
        this.avro = avro;
        this.progressConsumer = progressConsumer;
        this.errorConsumer = errorConsumer;
    }

    public Flux<ByteBuffer> read() {
        return new AvroReaderFactory().getAvroReader(this.avro).read().map(AvroObject::getObject).concatMap(this::parseRecord);
    }

    private Mono<ByteBuffer> parseRecord(Object quickQueryRecord) {
        if (!(quickQueryRecord instanceof Map)) {
            return Mono.error((Throwable)new IllegalArgumentException("Expected object to be of type Map"));
        }
        Map record = (Map)quickQueryRecord;
        Object recordSchema = record.get("$record");
        switch (recordSchema.toString()) {
            case "resultData": {
                return this.parseResultData(record);
            }
            case "end": {
                return this.parseEnd(record);
            }
            case "progress": {
                return this.parseProgress(record);
            }
            case "error": {
                return this.parseError(record);
            }
        }
        return Mono.error((Throwable)new IllegalStateException(String.format("Unknown record type %s while parsing query response. ", recordSchema.toString())));
    }

    private Mono<ByteBuffer> parseResultData(Map<?, ?> dataRecord) {
        Object data = dataRecord.get("data");
        if (BlobQueryReader.checkParametersNotNull(data)) {
            AvroSchema.checkType((String)"data", data, List.class);
            return Mono.just((Object)ByteBuffer.wrap(AvroSchema.getBytes((List)((List)data))));
        }
        return Mono.error((Throwable)new IllegalArgumentException("Failed to parse result data record from query response stream."));
    }

    private Mono<ByteBuffer> parseEnd(Map<?, ?> endRecord) {
        if (this.progressConsumer != null) {
            Object totalBytes = endRecord.get("totalBytes");
            if (BlobQueryReader.checkParametersNotNull(totalBytes)) {
                AvroSchema.checkType((String)"totalBytes", totalBytes, Long.class);
                this.progressConsumer.accept(new BlobQueryProgress((Long)totalBytes, (Long)totalBytes));
            } else {
                return Mono.error((Throwable)new IllegalArgumentException("Failed to parse end record from query response stream."));
            }
        }
        return Mono.empty();
    }

    private Mono<ByteBuffer> parseProgress(Map<?, ?> progressRecord) {
        if (this.progressConsumer != null) {
            Object bytesScanned = progressRecord.get("bytesScanned");
            Object totalBytes = progressRecord.get("totalBytes");
            if (BlobQueryReader.checkParametersNotNull(bytesScanned, totalBytes)) {
                AvroSchema.checkType((String)"bytesScanned", bytesScanned, Long.class);
                AvroSchema.checkType((String)"totalBytes", totalBytes, Long.class);
                this.progressConsumer.accept(new BlobQueryProgress((Long)bytesScanned, (Long)totalBytes));
            } else {
                return Mono.error((Throwable)new IllegalArgumentException("Failed to parse progress record from query response stream."));
            }
        }
        return Mono.empty();
    }

    private Mono<ByteBuffer> parseError(Map<?, ?> errorRecord) {
        BlobQueryError error;
        Object fatal = errorRecord.get("fatal");
        Object name = errorRecord.get("name");
        Object description = errorRecord.get("description");
        Object position = errorRecord.get("position");
        if (BlobQueryReader.checkParametersNotNull(fatal, name, description, position)) {
            AvroSchema.checkType((String)"fatal", fatal, Boolean.class);
            AvroSchema.checkType((String)"name", name, String.class);
            AvroSchema.checkType((String)"description", description, String.class);
            AvroSchema.checkType((String)"position", position, Long.class);
            error = new BlobQueryError((Boolean)fatal, (String)name, (String)description, (Long)position);
            if (this.errorConsumer == null) {
                return Mono.error((Throwable)new IOException("An error was reported during query response processing, " + System.lineSeparator() + error.toString()));
            }
        } else {
            return Mono.error((Throwable)new IllegalArgumentException("Failed to parse error record from query response stream."));
        }
        this.errorConsumer.accept(error);
        return Mono.empty();
    }

    private static boolean checkParametersNotNull(Object ... data) {
        for (Object o : data) {
            if (o != null && !(o instanceof AvroNullSchema.Null)) continue;
            return false;
        }
        return true;
    }

    public static QuerySerialization transformInputSerialization(BlobQuerySerialization userSerialization, ClientLogger logger) {
        if (userSerialization == null) {
            return null;
        }
        QueryFormat generatedFormat = new QueryFormat();
        if (userSerialization instanceof BlobQueryDelimitedSerialization) {
            generatedFormat.setType(QueryFormatType.DELIMITED);
            generatedFormat.setDelimitedTextConfiguration(BlobQueryReader.transformDelimited((BlobQueryDelimitedSerialization)userSerialization));
        } else if (userSerialization instanceof BlobQueryJsonSerialization) {
            generatedFormat.setType(QueryFormatType.JSON);
            generatedFormat.setJsonTextConfiguration(BlobQueryReader.transformJson((BlobQueryJsonSerialization)userSerialization));
        } else if (userSerialization instanceof BlobQueryParquetSerialization) {
            generatedFormat.setType(QueryFormatType.PARQUET);
            generatedFormat.setParquetTextConfiguration(BlobQueryReader.transformParquet((BlobQueryParquetSerialization)userSerialization));
        } else {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Please see values of valid input serialization in the documentation (https://docs.microsoft.com/rest/api/storageservices/query-blob-contents#request-body)."));
        }
        return new QuerySerialization().setFormat(generatedFormat);
    }

    public static QuerySerialization transformOutputSerialization(BlobQuerySerialization userSerialization, ClientLogger logger) {
        if (userSerialization == null) {
            return null;
        }
        QueryFormat generatedFormat = new QueryFormat();
        if (userSerialization instanceof BlobQueryDelimitedSerialization) {
            generatedFormat.setType(QueryFormatType.DELIMITED);
            generatedFormat.setDelimitedTextConfiguration(BlobQueryReader.transformDelimited((BlobQueryDelimitedSerialization)userSerialization));
        } else if (userSerialization instanceof BlobQueryJsonSerialization) {
            generatedFormat.setType(QueryFormatType.JSON);
            generatedFormat.setJsonTextConfiguration(BlobQueryReader.transformJson((BlobQueryJsonSerialization)userSerialization));
        } else if (userSerialization instanceof BlobQueryArrowSerialization) {
            generatedFormat.setType(QueryFormatType.ARROW);
            generatedFormat.setArrowConfiguration(BlobQueryReader.transformArrow((BlobQueryArrowSerialization)userSerialization));
        } else {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Please see values of valid output serialization in the documentation (https://docs.microsoft.com/rest/api/storageservices/query-blob-contents#request-body)."));
        }
        return new QuerySerialization().setFormat(generatedFormat);
    }

    private static DelimitedTextConfiguration transformDelimited(BlobQueryDelimitedSerialization delimitedSerialization) {
        if (delimitedSerialization == null) {
            return null;
        }
        return new DelimitedTextConfiguration().setColumnSeparator(BlobQueryReader.charToString(delimitedSerialization.getColumnSeparator())).setEscapeChar(BlobQueryReader.charToString(delimitedSerialization.getEscapeChar())).setFieldQuote(BlobQueryReader.charToString(delimitedSerialization.getFieldQuote())).setHeadersPresent(delimitedSerialization.isHeadersPresent()).setRecordSeparator(BlobQueryReader.charToString(delimitedSerialization.getRecordSeparator()));
    }

    private static JsonTextConfiguration transformJson(BlobQueryJsonSerialization jsonSerialization) {
        if (jsonSerialization == null) {
            return null;
        }
        return new JsonTextConfiguration().setRecordSeparator(BlobQueryReader.charToString(jsonSerialization.getRecordSeparator()));
    }

    private static Object transformParquet(BlobQueryParquetSerialization parquetSerialization) {
        if (parquetSerialization == null) {
            return null;
        }
        return new Object();
    }

    private static ArrowConfiguration transformArrow(BlobQueryArrowSerialization arrowSerialization) {
        ArrayList<ArrowField> schema;
        if (arrowSerialization == null) {
            return null;
        }
        ArrayList<ArrowField> arrayList = schema = arrowSerialization.getSchema() == null ? null : new ArrayList<ArrowField>(arrowSerialization.getSchema().size());
        if (schema != null) {
            for (BlobQueryArrowField field : arrowSerialization.getSchema()) {
                if (field == null) {
                    schema.add(null);
                    continue;
                }
                schema.add(new ArrowField().setName(field.getName()).setPrecision(field.getPrecision()).setScale(field.getScale()).setType(field.getType().toString()));
            }
        }
        return new ArrowConfiguration().setSchema(schema);
    }

    private static String charToString(char c) {
        return c == '\u0000' ? "" : Character.toString(c);
    }
}

