/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit.operator.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.BaseAuditOperator;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.repository.WorkerGroupDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerGroupAuditOperatorImpl
extends BaseAuditOperator {
    @Autowired
    private WorkerGroupDao workerGroupDao;

    @Override
    public void modifyAuditOperationType(AuditType auditType, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        if (auditType.getAuditOperationType() == AuditOperationType.CREATE && paramsMap.get("id") != null && !paramsMap.get("id").toString().equals("0")) {
            auditLogList.forEach(auditLog -> auditLog.setOperationType(AuditOperationType.UPDATE.getName()));
        }
    }

    @Override
    public String getObjectNameFromIdentity(Object identity) {
        Long objId = this.toLong(identity);
        if (objId == -1L) {
            return "";
        }
        WorkerGroup obj = (WorkerGroup)this.workerGroupDao.queryById((Serializable)objId);
        return obj == null ? "" : obj.getName();
    }
}

