/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.ProjectWorkerGroupRelationService;
import org.apache.dolphinscheduler.api.service.WorkerGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectWorkerGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.repository.ProjectWorkerGroupDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.WorkerGroupDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectWorkerGroupRelationServiceImpl
extends BaseServiceImpl
implements ProjectWorkerGroupRelationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectWorkerGroupRelationServiceImpl.class);
    @Autowired
    private ProjectWorkerGroupDao projectWorkerGroupDao;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private WorkerGroupDao workerGroupDao;
    @Autowired
    private WorkerGroupService workerGroupService;

    @Override
    public Result assignWorkerGroupsToProject(User loginUser, Long projectCode, List<String> workerGroups) {
        Result result = new Result();
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        if (Objects.isNull(projectCode)) {
            this.putMsg(result, Status.PROJECT_NOT_EXIST, new Object[0]);
            return result;
        }
        if (CollectionUtils.isEmpty(workerGroups)) {
            boolean deleted = this.projectWorkerGroupDao.deleteByProjectCode(projectCode);
            if (deleted) {
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                this.putMsg(result, Status.ASSIGN_WORKER_GROUP_TO_PROJECT_ERROR, new Object[0]);
            }
            return result;
        }
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        if (Objects.isNull(project)) {
            this.putMsg(result, Status.PROJECT_NOT_EXIST, new Object[0]);
            return result;
        }
        HashSet allWorkerGroupNames = new HashSet(this.workerGroupDao.queryAllWorkerGroupNames());
        this.workerGroupService.getConfigWorkerGroupPageDetail().forEach(workerGroupPageDetail -> allWorkerGroupNames.add(workerGroupPageDetail.getName()));
        HashSet<String> unauthorizedWorkerGroupNames = new HashSet<String>(workerGroups);
        SetUtils.SetView difference = SetUtils.difference(unauthorizedWorkerGroupNames, allWorkerGroupNames);
        if (!difference.isEmpty()) {
            this.putMsg(result, Status.WORKER_GROUP_NOT_EXIST, new Object[]{difference.toString()});
            return result;
        }
        Set projectWorkerGroupNames = this.projectWorkerGroupDao.queryAssignedWorkerGroupNamesByProjectCode(projectCode);
        difference = SetUtils.difference(unauthorizedWorkerGroupNames, (Set)projectWorkerGroupNames);
        Date now = new Date();
        if (CollectionUtils.isNotEmpty((Collection)difference)) {
            Set<String> usedWorkerGroups = this.getAllUsedWorkerGroups(project);
            if (CollectionUtils.isNotEmpty(usedWorkerGroups) && usedWorkerGroups.containsAll((Collection<?>)difference)) {
                throw new ServiceException(Status.USED_WORKER_GROUP_EXISTS, SetUtils.intersection(usedWorkerGroups, (Set)difference).toSet());
            }
            boolean deleted = this.projectWorkerGroupDao.deleteByProjectCodeAndWorkerGroups(projectCode, new ArrayList(difference));
            if (!deleted) {
                log.error("Failed to delete worker groups [{}] for the project [{}].", (Object)difference, (Object)project.getName());
                throw new ServiceException(Status.ASSIGN_WORKER_GROUP_TO_PROJECT_ERROR);
            }
            log.info("Success to delete worker groups [{}] for the project [{}] .", (Object)difference, (Object)project.getName());
            difference.forEach(workerGroupName -> {
                ProjectWorkerGroup projectWorkerGroup = new ProjectWorkerGroup();
                projectWorkerGroup.setProjectCode(projectCode);
                projectWorkerGroup.setWorkerGroup(workerGroupName);
                projectWorkerGroup.setCreateTime(now);
                projectWorkerGroup.setUpdateTime(now);
                int create = this.projectWorkerGroupDao.insert((Object)projectWorkerGroup);
                if (create <= 0) {
                    log.error("Failed to add worker group [{}] for the project [{}].", workerGroupName, (Object)project.getName());
                    throw new ServiceException(Status.ASSIGN_WORKER_GROUP_TO_PROJECT_ERROR);
                }
                log.info("Success to add worker group [{}] for the project [{}] .", workerGroupName, (Object)project.getName());
            });
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAssignedWorkerGroupsByProject(User loginUser, Long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode.longValue());
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, null);
        if (!hasProjectAndPerm) {
            return result;
        }
        Set<String> assignedWorkerGroups = this.getAllUsedWorkerGroups(project);
        this.projectWorkerGroupDao.queryByProjectCode(projectCode).forEach(projectWorkerGroup -> assignedWorkerGroups.add(projectWorkerGroup.getWorkerGroup()));
        List projectWorkerGroups = assignedWorkerGroups.stream().map(workerGroup -> {
            ProjectWorkerGroup projectWorkerGroup = new ProjectWorkerGroup();
            projectWorkerGroup.setProjectCode(projectCode);
            projectWorkerGroup.setWorkerGroup(workerGroup);
            return projectWorkerGroup;
        }).distinct().collect(Collectors.toList());
        result.put("data", projectWorkerGroups);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Set<String> getAllUsedWorkerGroups(Project project) {
        TreeSet<String> usedWorkerGroups = new TreeSet<String>();
        this.taskDefinitionDao.queryAllTaskDefinitionWorkerGroups(project.getCode()).forEach(workerGroupName -> {
            if (StringUtils.isNotEmpty((CharSequence)workerGroupName)) {
                usedWorkerGroups.add((String)workerGroupName);
            }
        });
        this.scheduleMapper.querySchedulerListByProjectName(project.getName()).stream().filter(schedule -> StringUtils.isNotEmpty((CharSequence)schedule.getWorkerGroup())).forEach(schedule -> usedWorkerGroups.add(schedule.getWorkerGroup()));
        return usedWorkerGroups;
    }
}

