/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatRule;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.TransportProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;

class LoadBalancerInboundNatRuleImpl
extends ChildResourceImpl<InboundNatRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerInboundNatRule,
LoadBalancerInboundNatRule.Definition<LoadBalancer.DefinitionStages.WithCreateAndInboundNatRule>,
LoadBalancerInboundNatRule.UpdateDefinition<LoadBalancer.Update>,
LoadBalancerInboundNatRule.Update {
    LoadBalancerInboundNatRuleImpl(InboundNatRuleInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String name() {
        return ((InboundNatRuleInner)((Object)this.innerModel())).name();
    }

    @Override
    public String backendNicIpConfigurationName() {
        if (((InboundNatRuleInner)((Object)this.innerModel())).backendIpConfiguration() == null) {
            return null;
        }
        return ResourceUtils.nameFromResourceId((String)((InboundNatRuleInner)((Object)this.innerModel())).backendIpConfiguration().id());
    }

    @Override
    public int backendPort() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((InboundNatRuleInner)((Object)this.innerModel())).backendPort());
    }

    @Override
    public String backendNetworkInterfaceId() {
        if (((InboundNatRuleInner)((Object)this.innerModel())).backendIpConfiguration() == null) {
            return null;
        }
        return ResourceUtils.parentResourceIdFromResourceId((String)((InboundNatRuleInner)((Object)this.innerModel())).backendIpConfiguration().id());
    }

    @Override
    public TransportProtocol protocol() {
        return ((InboundNatRuleInner)((Object)this.innerModel())).protocol();
    }

    @Override
    public int frontendPort() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((InboundNatRuleInner)((Object)this.innerModel())).frontendPort());
    }

    @Override
    public boolean floatingIPEnabled() {
        return ((InboundNatRuleInner)((Object)this.innerModel())).enableFloatingIp();
    }

    @Override
    public LoadBalancerFrontend frontend() {
        return ((LoadBalancerImpl)this.parent()).frontends().get(ResourceUtils.nameFromResourceId((String)((InboundNatRuleInner)((Object)this.innerModel())).frontendIpConfiguration().id()));
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((InboundNatRuleInner)((Object)this.innerModel())).idleTimeoutInMinutes());
    }

    @Override
    public LoadBalancerInboundNatRuleImpl toBackendPort(int port) {
        ((InboundNatRuleInner)((Object)this.innerModel())).withBackendPort(port);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withFloatingIPEnabled() {
        return this.withFloatingIP(true);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withFloatingIPDisabled() {
        return this.withFloatingIP(false);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withFloatingIP(boolean enabled) {
        ((InboundNatRuleInner)((Object)this.innerModel())).withEnableFloatingIp(enabled);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromFrontendPort(int port) {
        ((InboundNatRuleInner)((Object)this.innerModel())).withFrontendPort(port);
        if (this.backendPort() == 0) {
            return this.toBackendPort(port);
        }
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((InboundNatRuleInner)((Object)this.innerModel())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl withProtocol(TransportProtocol protocol) {
        ((InboundNatRuleInner)((Object)this.innerModel())).withProtocol(protocol);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromFrontend(String frontendName) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(frontendName);
        if (frontendRef != null) {
            ((InboundNatRuleInner)((Object)this.innerModel())).withFrontendIpConfiguration(frontendRef);
        }
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withInboundNatRule(this);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingPublicIPAddress(PublicIpAddress publicIPAddress) {
        return publicIPAddress != null ? this.fromExistingPublicIPAddress(publicIPAddress.id()) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingPublicIPAddress(String resourceId) {
        return null != resourceId ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePublicFrontendWithPip(resourceId).name()) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromNewPublicIPAddress(String leafDnsLabel) {
        String frontendName = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(leafDnsLabel, frontendName);
        this.fromFrontend(frontendName);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromNewPublicIPAddress(Creatable<PublicIpAddress> pipDefinition) {
        String frontendName = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        ((LoadBalancerImpl)this.parent()).withNewPublicIPAddress(pipDefinition, frontendName);
        this.fromFrontend(frontendName);
        return this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromNewPublicIPAddress() {
        String dnsLabel = ((NetworkManager)((LoadBalancerImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("fe", 20);
        return this.fromNewPublicIPAddress(dnsLabel);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingSubnet(String networkResourceId, String subnetName) {
        return null != networkResourceId && null != subnetName ? this.fromFrontend(((LoadBalancerImpl)this.parent()).ensurePrivateFrontendWithSubnet(networkResourceId, subnetName).name()) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingSubnet(Network network, String subnetName) {
        return null != network && null != subnetName ? this.fromExistingSubnet(network.id(), subnetName) : this;
    }

    @Override
    public LoadBalancerInboundNatRuleImpl fromExistingSubnet(Subnet subnet) {
        return null != subnet ? this.fromExistingSubnet(((Network)subnet.parent()).id(), subnet.name()) : this;
    }
}

