/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.models.ExpressRouteCircuitSku;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitSkuFamily;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitSkuTier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ExpressRouteCircuitSkuType {
    private static final Map<String, ExpressRouteCircuitSkuType> VALUES_BY_NAME = new HashMap<String, ExpressRouteCircuitSkuType>();
    public static final ExpressRouteCircuitSkuType STANDARD_METEREDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.STANDARD, ExpressRouteCircuitSkuFamily.METERED_DATA);
    public static final ExpressRouteCircuitSkuType STANDARD_UNLIMITEDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.STANDARD, ExpressRouteCircuitSkuFamily.UNLIMITED_DATA);
    public static final ExpressRouteCircuitSkuType PREMIUM_METEREDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.PREMIUM, ExpressRouteCircuitSkuFamily.METERED_DATA);
    public static final ExpressRouteCircuitSkuType PREMIUM_UNLIMITEDDATA = new ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier.PREMIUM, ExpressRouteCircuitSkuFamily.UNLIMITED_DATA);
    private final ExpressRouteCircuitSku sku;
    private final String value;

    public static ExpressRouteCircuitSkuType[] values() {
        Collection<ExpressRouteCircuitSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new ExpressRouteCircuitSkuType[valuesCollection.size()]);
    }

    public ExpressRouteCircuitSkuType(ExpressRouteCircuitSkuTier skuTier, ExpressRouteCircuitSkuFamily skuFamily) {
        this(new ExpressRouteCircuitSku().withName((skuTier == null ? "" : skuTier.toString()) + "_" + (skuFamily == null ? "" : skuFamily.toString())).withTier(skuTier).withFamily(skuFamily));
    }

    public ExpressRouteCircuitSkuType(ExpressRouteCircuitSku sku) {
        this.sku = ExpressRouteCircuitSkuType.createCopy(sku);
        this.value = this.sku.name();
        VALUES_BY_NAME.put(this.value.toLowerCase(Locale.ROOT), this);
    }

    public static ExpressRouteCircuitSkuType fromSku(ExpressRouteCircuitSku sku) {
        if (sku == null) {
            return null;
        }
        String nameToLookFor = sku.name();
        ExpressRouteCircuitSkuType result = VALUES_BY_NAME.get(nameToLookFor.toLowerCase(Locale.ROOT));
        if (result != null) {
            return result;
        }
        return new ExpressRouteCircuitSkuType(sku);
    }

    public ExpressRouteCircuitSku sku() {
        return ExpressRouteCircuitSkuType.createCopy(this.sku);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpressRouteCircuitSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.value == null) {
            return ((ExpressRouteCircuitSkuType)obj).value == null;
        }
        return this.value.equalsIgnoreCase(((ExpressRouteCircuitSkuType)obj).value.toLowerCase(Locale.ROOT));
    }

    private static ExpressRouteCircuitSku createCopy(ExpressRouteCircuitSku sku) {
        return new ExpressRouteCircuitSku().withName(sku.name()).withTier(sku.tier()).withFamily(sku.family());
    }
}

