/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public enum AlertInputTips {
    PASSWORD("if enable use authentication, you need input password", "\u5982\u679c\u5f00\u542f\u9274\u6743\u6821\u9a8c\uff0c\u5219\u9700\u8981\u8f93\u5165\u5bc6\u7801"),
    USERNAME("if enable use authentication, you need input user", "\u5982\u679c\u5f00\u542f\u9274\u6743\u6821\u9a8c\uff0c\u5219\u9700\u8981\u8f93\u5165\u8d26\u53f7"),
    RECEIVERS("please input receivers", "\u8bf7\u8f93\u5165\u6536\u4ef6\u4eba"),
    URL("input request URL", "\u8bf7\u8f93\u5165\u8bf7\u6c42\u7684URL"),
    HEADER("input request headers as JSON format", "\u8bf7\u8f93\u5165JSON\u683c\u5f0f\u7684\u8bf7\u6c42\u5934"),
    JSON_BODY("input request body as JSON format", "\u8bf7\u8f93\u5165JSON\u683c\u5f0f\u7684\u8bf7\u6c42\u4f53"),
    FIELD_NAME("input alert msg field name", "\u8bf7\u8f93\u5165\u544a\u8b66\u4fe1\u606f\u7684\u5185\u5bb9\u5b57\u6bb5\u540d\u79f0"),
    HTTP_METHOD("input request type POST or GET", "\u8bf7\u8f93\u5165HTTP\u8bf7\u6c42\u7c7b\u578bPOST\u6216GET"),
    CUSTOMIZED_PARAMS("the custom parameters passed when calling scripts", "\u8bf7\u8f93\u5165\u8c03\u7528\u811a\u672c\u65f6\u4f20\u5165\u7684\u81ea\u5b9a\u4e49\u53c2\u6570"),
    SCRIPT_PATH("the absolute script path under alert-server, and make sure access rights", "\u8bf7\u8f93\u5165alert-server\u673a\u5668\u7684\u811a\u672c\u7684\u7edd\u5bf9\u8def\u5f84\uff0c\u5e76\u786e\u4fdd\u6587\u4ef6\u6709\u6743\u63a5\u5165"),
    WEBHOOK("input WebHook Url", "\u8bf7\u8f93\u5165webhook\u7684url"),
    BOT_NAME("input the bot username", "\u8bf7\u8f93\u5165bot\u7684\u540d\u79f0"),
    BOT_TOKEN("input bot access token", "\u8bf7\u8f93\u5165bot\u7684\u63a5\u5165token"),
    CHANNEL_ID("input telegram channel chat id", "\u8bf7\u8f93\u5165telegram\u7684\u9891\u9053chat id"),
    ROOM_ID("input the room ID the alert message send to", "\u8bf7\u8f93\u5165\u544a\u8b66\u4fe1\u606f\u53d1\u9001\u7684room ID"),
    RECIPIENT_USER_ID("input the person ID of the alert message recipient", "\u8bf7\u8f93\u5165\u544a\u8b66\u4fe1\u606f\u63a5\u6536\u4eba\u7684person ID"),
    RECIPIENT_EMAIL("input the email address of the alert message recipient", "\u8bf7\u8f93\u5165\u544a\u8b66\u4fe1\u606f\u63a5\u6536\u4eba\u7684email\u5730\u5740"),
    WEBEX_MENTION_USERS("use `,`(eng commas) to separate multiple emails, to specify the person you mention in the room", "\u4f7f\u7528 `, `\u6765\u5206\u5272\u591a\u4e2aemail\uff0c\u6765\u6307\u51fa\u5728\u623f\u95f4\u4e2d\u8981@\u7684\u4eba"),
    CORP_ID("please input corp id", "\u8bf7\u8f93\u5165corp id"),
    SECRET("please input secret", "\u8bf7\u8f93\u5165secret"),
    WECHAT_MENTION_USERS("use `|` to separate userIds and `@all` to everyone", "\u4f7f\u7528`|`\u6765\u5206\u5272userId\u6216\u4f7f\u7528`@all`\u6765\u63d0\u5230\u6240\u6709\u4eba"),
    WECHAT_AGENT_ID("please input agent id or chat id", "\u8bf7\u8f93\u5165agent id\u6216chat id"),
    CALLED_NUMBER("please input called number", "\u8bf7\u8f93\u5165\u88ab\u53eb\u7535\u8bdd\u53f7\u7801"),
    CALLED_SHOW_NUMBER("Please enter the call display number (the default number will be used if you do not fill in)", "\u8bf7\u8f93\u5165\u547c\u53eb\u663e\u793a\u53f7\u7801(\u4e0d\u586b\u5219\u4f7f\u7528\u9ed8\u8ba4\u53f7\u7801)"),
    TTS_CODE("please input tts code", "\u8bf7\u8f93\u5165\u8bed\u97f3\u6a21\u677f\u7f16\u7801"),
    ALIYUN_VIICE_ADDRESS("please input aliyun viice address", "\u8bf7\u8f93\u5165\u963f\u91cc\u4e91\u8bbf\u95ee\u57df\u540d"),
    ALIYUN_VIICE_ACCESSKEYID("please input accessKeyId", "\u8bf7\u8f93\u5165accessKeyId"),
    ALIYUN_VIICE_ACCESSKEY_SECRET("please input accessKeySecret", "\u8bf7\u8f93\u5165accessKeySecret"),
    ANNOTATION("please input annotation in json form", "\u8bf7\u8f93\u5165json\u683c\u5f0f\u7684annotation"),
    GENERATOR_URL("please input Generator URL", "\u8bf7\u8f93\u5165\u751f\u6210\u5730\u5740");

    private final String enMsg;
    private final String zhMsg;

    private AlertInputTips(String enMsg, String zhMsg) {
        this.enMsg = enMsg;
        this.zhMsg = zhMsg;
    }

    public String getMsg() {
        if (Locale.SIMPLIFIED_CHINESE.getLanguage().equals(LocaleContextHolder.getLocale().getLanguage())) {
            return this.zhMsg;
        }
        return this.enMsg;
    }

    public static Map<String, String> getAllMsg(AlertInputTips alertInputTips) {
        HashMap<String, String> allMsgMap = new HashMap<String, String>();
        allMsgMap.put("zhMsg", alertInputTips.zhMsg);
        allMsgMap.put("enMsg", alertInputTips.enMsg);
        return allMsgMap;
    }
}

