/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.params.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import java.util.Objects;
import org.apache.dolphinscheduler.spi.params.base.FormType;
import org.apache.dolphinscheduler.spi.params.base.ParamsProps;
import org.apache.dolphinscheduler.spi.params.base.Validate;

@JsonDeserialize(builder=Builder.class)
public class PluginParams {
    @JsonProperty(value="field")
    protected String name;
    @JsonProperty(value="name")
    protected String fieldName;
    @JsonProperty(value="props")
    protected ParamsProps props;
    @JsonProperty(value="type")
    protected String formType;
    @JsonProperty(value="title")
    protected String title;
    protected String info;
    @JsonProperty(value="value")
    protected Object value;
    @JsonProperty(value="validate")
    protected List<Validate> validateList;
    @JsonProperty(value="emit")
    protected List<String> emit;
    protected Boolean hidden;
    protected Boolean display;

    protected PluginParams(Builder builder) {
        Objects.requireNonNull(builder, "builder is null");
        Objects.requireNonNull(builder.name, "name is null");
        Objects.requireNonNull(builder.formType, "formType is null");
        Objects.requireNonNull(builder.title, "title is null");
        this.name = builder.name;
        this.formType = builder.formType.getFormType();
        this.title = builder.title;
        if (null == builder.props) {
            builder.props = new ParamsProps();
        }
        this.fieldName = builder.title;
        this.props = builder.props;
        this.value = builder.value;
        this.validateList = builder.validateList;
        this.info = builder.info;
        this.display = builder.display;
        this.hidden = builder.hidden;
        this.emit = builder.emit;
    }

    public String getName() {
        return this.name;
    }

    public ParamsProps getProps() {
        return this.props;
    }

    public String getFormType() {
        return this.formType;
    }

    public String getTitle() {
        return this.title;
    }

    public Object getValue() {
        return this.value;
    }

    public List<Validate> getValidateList() {
        return this.validateList;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public List<String> getEmit() {
        return this.emit;
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="set")
    public static class Builder {
        protected String name;
        protected FormType formType;
        protected String title;
        protected String fieldName;
        protected ParamsProps props;
        protected Object value;
        protected String info;
        protected List<Validate> validateList;
        protected List<String> emit;
        protected Boolean hidden;
        protected Boolean display;

        public Builder(String name, FormType formType, String title) {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(formType, "formType is null");
            Objects.requireNonNull(title, "title is null");
            this.name = name;
            this.formType = formType;
            this.title = title;
            this.fieldName = title;
        }

        @JsonCreator
        public Builder(@JsonProperty(value="field") String name, @JsonProperty(value="type") FormType formType, @JsonProperty(value="title") String title, @JsonProperty(value="props") ParamsProps props, @JsonProperty(value="value") Object value, @JsonProperty(value="name") String fieldName, @JsonProperty(value="validate") List<Validate> validateList, @JsonProperty(value="emit") List<String> emit, @JsonProperty(value="info") String info, @JsonProperty(value="hidden") Boolean hidden, @JsonProperty(value="display") Boolean display) {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(formType, "formType is null");
            Objects.requireNonNull(title, "title is null");
            this.name = name;
            this.formType = formType;
            this.title = title;
            this.props = props;
            this.value = value;
            this.validateList = validateList;
            this.fieldName = fieldName;
            this.emit = emit;
            this.info = info;
            this.hidden = hidden;
            this.display = display;
        }

        public PluginParams build() {
            return new PluginParams(this);
        }
    }
}

