/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.model.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.exception.AggregatedManagementException;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Executable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreateUpdateTask;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public abstract class CreatableUpdatableImpl<FluentModelT extends Indexable, InnerModelT, FluentModelImplT extends IndexableRefreshableWrapperImpl<FluentModelT, InnerModelT>>
extends IndexableRefreshableWrapperImpl<FluentModelT, InnerModelT>
implements Appliable<FluentModelT>,
Creatable<FluentModelT>,
TaskGroup.HasTaskGroup,
CreateUpdateTask.ResourceCreatorUpdater<FluentModelT> {
    private final String name;
    private final TaskGroup taskGroup;

    protected CreatableUpdatableImpl(String name, InnerModelT innerObject) {
        this(name, UUID.randomUUID().toString(), innerObject);
    }

    protected CreatableUpdatableImpl(String name, String key, InnerModelT innerObject) {
        super(key, innerObject);
        this.name = name;
        this.taskGroup = new TaskGroup(this.key(), new CreateUpdateTask(this));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TaskGroup taskGroup() {
        return this.taskGroup;
    }

    protected String addDependency(FunctionalTaskItem dependency) {
        Objects.requireNonNull(dependency);
        return this.taskGroup.addDependency(dependency);
    }

    protected String addDependency(TaskGroup.HasTaskGroup dependency) {
        Objects.requireNonNull(dependency);
        this.taskGroup.addDependencyTaskGroup(dependency.taskGroup());
        return dependency.taskGroup().key();
    }

    protected String addDependency(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addDependency(dependency);
    }

    public String addPostRunDependent(FunctionalTaskItem dependent) {
        Objects.requireNonNull(dependent);
        return this.taskGroup().addPostRunDependent(dependent);
    }

    protected String addPostRunDependent(TaskGroup.HasTaskGroup dependent) {
        Objects.requireNonNull(dependent);
        this.taskGroup.addPostRunDependentTaskGroup(dependent.taskGroup());
        return dependent.taskGroup().key();
    }

    protected String addPostRunDependent(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addPostRunDependent(dependency);
    }

    protected void addPostRunDependent(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        this.addPostRunDependent(dependency);
    }

    @Override
    public void beforeGroupCreateOrUpdate() {
    }

    @Override
    public Mono<FluentModelT> createAsync() {
        return this.createOrUpdateAsync();
    }

    @Override
    public Mono<FluentModelT> applyAsync() {
        return this.createOrUpdateAsync();
    }

    @Override
    public Mono<FluentModelT> createAsync(Context context) {
        return this.invokeTaskGroupAsync(context);
    }

    @Override
    public Mono<FluentModelT> applyAsync(Context context) {
        return this.invokeTaskGroupAsync(context);
    }

    public Mono<FluentModelT> createOrUpdateAsync() {
        return this.taskGroup.invokeAsync().map(indexable -> indexable).onErrorMap(AggregatedManagementException::convertToManagementException);
    }

    private Mono<FluentModelT> invokeTaskGroupAsync(Context context) {
        return this.taskGroup().invokeAsync().contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).map(indexable -> indexable).onErrorMap(AggregatedManagementException::convertToManagementException);
    }

    @Override
    public boolean isHot() {
        return false;
    }

    @Override
    public FluentModelT create() {
        return (FluentModelT)((Indexable)this.createAsync().block());
    }

    @Override
    public FluentModelT apply() {
        return (FluentModelT)((Indexable)this.applyAsync().block());
    }

    @Override
    public FluentModelT create(Context context) {
        return (FluentModelT)((Indexable)this.createAsync(context).block());
    }

    @Override
    public FluentModelT apply(Context context) {
        return (FluentModelT)((Indexable)this.applyAsync(context).block());
    }

    public FluentModelImplT update() {
        return (FluentModelImplT)this;
    }

    @Override
    public Mono<FluentModelT> updateResourceAsync() {
        return this.createResourceAsync();
    }

    protected <T extends Indexable> T taskResult(String key) {
        Indexable result = this.taskGroup.taskResult(key);
        if (result == null) {
            return null;
        }
        Indexable castedResult = result;
        return (T)castedResult;
    }

    protected Function<InnerModelT, FluentModelT> innerToFluentMap(FluentModelImplT fluentModelImplT) {
        return innerModel -> {
            fluentModelImplT.setInner(innerModel);
            return fluentModelImplT;
        };
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        return Mono.empty();
    }
}

