/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.services.internal.Constants;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.utils.DefaultAuthentication;
import com.obs.services.internal.utils.IAuthentication;
import com.obs.services.internal.utils.ServiceUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class V4Authentication {
    public static final String CONTENT_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private String ak;
    private String sk;
    private String region;
    private String nowISOtime;

    protected V4Authentication() {
    }

    public String getAk() {
        return this.ak;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public String getSk() {
        return this.sk;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public static String caculateSignature(String stringToSign, String shortDate, String sk) throws Exception {
        byte[] dateKey = V4Authentication.hmacSha256Encode(("AWS4" + sk).getBytes(StandardCharsets.UTF_8), shortDate);
        byte[] dataRegionKey = V4Authentication.hmacSha256Encode(dateKey, "region");
        byte[] dateRegionServiceKey = V4Authentication.hmacSha256Encode(dataRegionKey, "s3");
        byte[] signingKey = V4Authentication.hmacSha256Encode(dateRegionServiceKey, "aws4_request");
        return V4Authentication.byteToHex(V4Authentication.hmacSha256Encode(signingKey, stringToSign));
    }

    public static IAuthentication makeServiceCanonicalString(String method, Map<String, String> headers, String strURIPath, ProviderCredentials credent, Date date, BasicSecurityKey securityKey) throws ServiceException {
        V4Authentication v4 = new V4Authentication();
        v4.setAk(securityKey.getAccessKey());
        v4.setSk(securityKey.getSecretKey());
        v4.setRegion(credent.getRegion());
        v4.setNowISOTime(date);
        List<String> signedAndCanonicalList = v4.getSignedAndCanonicalHeaders(headers);
        String scope = v4.getScope();
        try {
            String canonicalRequest = v4.getCanonicalRequest(method, strURIPath, signedAndCanonicalList);
            String stringToSign = "AWS4-HMAC-SHA256" + "\n" + v4.nowISOtime + "\n" + scope + "\n" + V4Authentication.byteToHex(V4Authentication.sha256encode(canonicalRequest));
            String signature = V4Authentication.byteToHex(V4Authentication.hmacSha256Encode(v4.getSigningKey(), stringToSign));
            String auth = "AWS4-HMAC-SHA256" + " Credential=" + v4.ak + "/" + scope + ",SignedHeaders=" + signedAndCanonicalList.get(0) + ",Signature=" + signature;
            return new DefaultAuthentication(canonicalRequest, stringToSign, auth);
        }
        catch (Exception e) {
            throw new ServiceException("has an err when V4 aurhentication ", e);
        }
    }

    private void setNowISOTime(Date headerDate) {
        SimpleDateFormat fmt1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        fmt1.setTimeZone(Constants.GMT_TIMEZONE);
        this.nowISOtime = fmt1.format(headerDate);
    }

    private List<String> getSignedAndCanonicalHeaders(Map<String, String> headers) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder signed = new StringBuilder();
        StringBuilder canonical = new StringBuilder();
        TreeMap<String, ArrayList<String>> map = new TreeMap<String, ArrayList<String>>();
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || "".equals(key) || "connection".equalsIgnoreCase(key)) continue;
                String lk = key.toLowerCase(Locale.getDefault());
                ArrayList<String> values2 = (ArrayList<String>)map.get(lk);
                if (values2 == null) {
                    values2 = new ArrayList<String>();
                    map.put(lk, values2);
                }
                values2.add(value);
            }
            boolean i = false;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                List values3 = (List)entry.getValue();
                if (i) {
                    signed.append(";");
                }
                i = true;
                signed.append(key);
                for (String value : values3) {
                    canonical.append(key).append(":").append(value).append("\n");
                }
            }
        }
        list.add(signed.toString());
        list.add(canonical.toString());
        return list;
    }

    private List<String> getCanonicalURIAndQuery(String fulPath) throws ServiceException {
        String url = "";
        String query = "";
        String[] pathStrings = fulPath.split("[?]");
        if (pathStrings.length > 0) {
            url = url + pathStrings[0];
        }
        if (pathStrings.length > 1) {
            String[] uri = pathStrings[1].split("[&]");
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int i = 0; i < uri.length; ++i) {
                String[] kvStrings = uri[i].split("[=]");
                String key = kvStrings[0];
                String val = "";
                if (kvStrings.length > 1) {
                    val = kvStrings[1];
                }
                map.put(key, val);
            }
            boolean j = false;
            StringBuilder tempStr = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (j) {
                    tempStr.append("&");
                }
                j = true;
                tempStr.append(key.toString()).append("=").append(value.toString());
            }
            query = tempStr.toString();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(url);
        list.add(query);
        return list;
    }

    private String getScope() {
        return this.nowISOtime.split("T")[0] + "/" + this.region + "/" + "s3" + "/" + "aws4_request";
    }

    private String getCanonicalRequest(String method, String fulPath, List<String> canonical) throws ServiceException {
        List<String> list = this.getCanonicalURIAndQuery(fulPath);
        StringBuilder outPut = new StringBuilder(method).append("\n").append(list.get(0)).append("\n").append(list.get(1)).append("\n").append(canonical.get(1)).append("\n").append(canonical.get(0)).append("\n").append(CONTENT_SHA256);
        return outPut.toString();
    }

    private byte[] getSigningKey() throws ServiceException {
        String shortDate = this.nowISOtime.split("[T]")[0];
        String keyString = "AWS4" + this.sk;
        try {
            byte[] dateKey = V4Authentication.hmacSha256Encode(keyString.getBytes(StandardCharsets.UTF_8), shortDate);
            byte[] dateRegionKey = V4Authentication.hmacSha256Encode(dateKey, this.region);
            byte[] dateRegionServiceKey = V4Authentication.hmacSha256Encode(dateRegionKey, "s3");
            return V4Authentication.hmacSha256Encode(dateRegionServiceKey, "aws4_request");
        }
        catch (Exception e) {
            throw new ServiceException("Get sign string for v4 aurhentication error", e);
        }
    }

    public static byte[] hmacSha256Encode(byte[] key, String data) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        Mac sha256HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretkey = new SecretKeySpec(key, "HmacSHA256");
        sha256HMAC.init(secretkey);
        return sha256HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha256encode(String str) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] hash = null;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        hash = digest.digest(str.getBytes(StandardCharsets.UTF_8));
        return hash;
    }

    public static String byteToHex(byte[] hash) {
        return ServiceUtils.toHex(hash);
    }
}

