/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.WebhookAction;
import com.azure.resourcemanager.containerregistry.models.WebhookStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class WebhookPropertiesCreateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebhookPropertiesCreateParameters.class);
    @JsonProperty(value="serviceUri", required=true)
    private String serviceUri;
    @JsonProperty(value="customHeaders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> customHeaders;
    @JsonProperty(value="status")
    private WebhookStatus status;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="actions", required=true)
    private List<WebhookAction> actions;

    public String serviceUri() {
        return this.serviceUri;
    }

    public WebhookPropertiesCreateParameters withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Map<String, String> customHeaders() {
        return this.customHeaders;
    }

    public WebhookPropertiesCreateParameters withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public WebhookStatus status() {
        return this.status;
    }

    public WebhookPropertiesCreateParameters withStatus(WebhookStatus status) {
        this.status = status;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public WebhookPropertiesCreateParameters withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public List<WebhookAction> actions() {
        return this.actions;
    }

    public WebhookPropertiesCreateParameters withActions(List<WebhookAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.serviceUri() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property serviceUri in model WebhookPropertiesCreateParameters"));
        }
        if (this.actions() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property actions in model WebhookPropertiesCreateParameters"));
        }
    }
}

