/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSBuilder;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.StringUtils;

public class OSSClientBuilder
implements OSSBuilder {
    @Override
    public OSS build(String endpoint, String accessKeyId, String secretAccessKey) {
        return new OSSClient(endpoint, OSSClientBuilder.getDefaultCredentialProvider(accessKeyId, secretAccessKey), OSSClientBuilder.getClientConfiguration());
    }

    @Override
    public OSS build(String endpoint, String accessKeyId, String secretAccessKey, String securityToken) {
        return new OSSClient(endpoint, OSSClientBuilder.getDefaultCredentialProvider(accessKeyId, secretAccessKey, securityToken), OSSClientBuilder.getClientConfiguration());
    }

    @Override
    public OSS build(String endpoint, String accessKeyId, String secretAccessKey, ClientBuilderConfiguration config) {
        return new OSSClient(endpoint, OSSClientBuilder.getDefaultCredentialProvider(accessKeyId, secretAccessKey), OSSClientBuilder.getClientConfiguration(config));
    }

    @Override
    public OSS build(String endpoint, String accessKeyId, String secretAccessKey, String securityToken, ClientBuilderConfiguration config) {
        return new OSSClient(endpoint, OSSClientBuilder.getDefaultCredentialProvider(accessKeyId, secretAccessKey, securityToken), OSSClientBuilder.getClientConfiguration(config));
    }

    @Override
    public OSS build(String endpoint, CredentialsProvider credsProvider) {
        return new OSSClient(endpoint, credsProvider, OSSClientBuilder.getClientConfiguration());
    }

    @Override
    public OSS build(String endpoint, CredentialsProvider credsProvider, ClientBuilderConfiguration config) {
        return new OSSClient(endpoint, credsProvider, OSSClientBuilder.getClientConfiguration(config));
    }

    private static ClientBuilderConfiguration getClientConfiguration() {
        return new ClientBuilderConfiguration();
    }

    private static ClientBuilderConfiguration getClientConfiguration(ClientBuilderConfiguration config) {
        if (config == null) {
            config = new ClientBuilderConfiguration();
        }
        return config;
    }

    private static DefaultCredentialProvider getDefaultCredentialProvider(String accessKeyId, String secretAccessKey) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey);
    }

    private static DefaultCredentialProvider getDefaultCredentialProvider(String accessKeyId, String secretAccessKey, String securityToken) {
        return new DefaultCredentialProvider(accessKeyId, secretAccessKey, securityToken);
    }

    public static OSSClientBuilderImpl create() {
        return new OSSClientBuilderImpl();
    }

    static /* synthetic */ ClientBuilderConfiguration access$100() {
        return OSSClientBuilder.getClientConfiguration();
    }

    public static final class OSSClientBuilderImpl {
        private String endpoint;
        private CredentialsProvider credentialsProvider;
        private ClientConfiguration clientConfiguration = OSSClientBuilder.access$100();
        private String region;
        private String cloudBoxId;

        private OSSClientBuilderImpl() {
        }

        public OSSClientBuilderImpl endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public OSSClientBuilderImpl credentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public OSSClientBuilderImpl clientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public OSSClientBuilderImpl region(String region) {
            this.region = region;
            return this;
        }

        public OSSClientBuilderImpl cloudBoxId(String cloudBoxId) {
            this.cloudBoxId = cloudBoxId;
            return this;
        }

        public OSS build() {
            CodingUtils.assertParameterNotNull(this.endpoint, "endpoint");
            CodingUtils.assertParameterNotNull(this.credentialsProvider, "credentialsProvider");
            CodingUtils.assertParameterNotNull(this.clientConfiguration, "clientConfiguration");
            if (SignVersion.V4.equals((Object)this.clientConfiguration.getSignatureVersion())) {
                CodingUtils.assertParameterNotNull(this.region, "region");
            }
            OSSClient client = new OSSClient(this.endpoint, this.credentialsProvider, this.clientConfiguration);
            if (!StringUtils.isNullOrEmpty(this.region)) {
                client.setRegion(this.region);
            }
            if (!StringUtils.isNullOrEmpty(this.cloudBoxId)) {
                client.setProduct("oss-cloudbox");
                client.setCloudBoxId(this.cloudBoxId);
            }
            return client;
        }
    }
}

