/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.abs;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.specialized.BlockBlobClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.plugin.storage.abs.AbsStorageProperties;
import org.apache.dolphinscheduler.plugin.storage.api.AbstractStorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsStorageOperator
extends AbstractStorageOperator
implements Closeable,
StorageOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbsStorageOperator.class);
    private final BlobContainerClient blobContainerClient;
    private final BlobServiceClient blobServiceClient;

    public AbsStorageOperator(AbsStorageProperties absStorageProperties) {
        super(absStorageProperties.getResourceUploadPath());
        this.blobServiceClient = new BlobServiceClientBuilder().endpoint("https://" + absStorageProperties.getStorageAccountName() + ".blob.core.windows.net/").connectionString(absStorageProperties.getConnectionString()).buildClient();
        this.blobContainerClient = this.blobServiceClient.getBlobContainerClient(absStorageProperties.getContainerName());
        this.checkContainerNameExists(absStorageProperties.getContainerName());
    }

    public String getStorageBaseDirectory() {
        if (this.getStorageBaseDirectory().startsWith("/")) {
            log.warn("{} -> {} should not start with / in abs", (Object)"resource.storage.upload.base.path", (Object)this.getStorageBaseDirectory());
            return this.getStorageBaseDirectory().substring(1);
        }
        return this.getStorageBaseDirectory();
    }

    public void createStorageDir(String directory) {
        String objectName = directory + "/";
        if (this.isObjectExists(objectName)) {
            throw new FileAlreadyExistsException("directory: " + objectName + " already exists");
        }
        BlobClient blobClient = this.blobContainerClient.getBlobClient(objectName);
        blobClient.upload((InputStream)new ByteArrayInputStream("".getBytes()), 0L);
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) {
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWithPermission((Path)dstFile.getParentFile().toPath(), (Set)FileUtils.PERMISSION_755);
        }
        BlobClient blobClient = this.blobContainerClient.getBlobClient(srcFilePath);
        blobClient.downloadToFile(dstFilePath, true);
    }

    public boolean exists(String fullName) {
        return this.isObjectExists(fullName);
    }

    protected boolean isObjectExists(String objectName) {
        return this.blobContainerClient.getBlobClient(objectName).exists();
    }

    public void delete(String filePath, boolean recursive) {
        this.blobContainerClient.getBlobClient(filePath).deleteIfExists();
    }

    public void copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) {
        BlobClient srcBlobClient = this.blobContainerClient.getBlobClient(srcPath);
        BlockBlobClient dstBlobClient = this.blobContainerClient.getBlobClient(dstPath).getBlockBlobClient();
        dstBlobClient.uploadFromUrl(srcBlobClient.getBlobUrl(), overwrite);
        if (deleteSource) {
            srcBlobClient.delete();
        }
    }

    public void upload(String srcFile, String dstPath, boolean deleteSource, boolean overwrite) {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(dstPath);
        blobClient.uploadFromFile(srcFile, overwrite);
        Path srcPath = Paths.get(srcFile, new String[0]);
        if (deleteSource) {
            Files.delete(srcPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> fetchFileContent(String filePath, int skipLineNums, int limit) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.error("file path:{} is blank", (Object)filePath);
            return Collections.emptyList();
        }
        BlobClient blobClient = this.blobContainerClient.getBlobClient(filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(blobClient.downloadContent().toBytes())));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void close() throws IOException {
    }

    public List<StorageEntity> listStorageEntity(String resourceAbsolutePath) {
        return null;
    }

    public List<StorageEntity> listFileStorageEntityRecursively(String resourceAbsolutePath) {
        return null;
    }

    public StorageEntity getStorageEntity(String resourceAbsolutePath) {
        return null;
    }

    public void checkContainerNameExists(String containerName) {
        if (StringUtils.isBlank((CharSequence)containerName)) {
            throw new IllegalArgumentException(containerName + " is blank");
        }
        boolean exist = false;
        for (BlobContainerItem item : this.blobServiceClient.listBlobContainers()) {
            if (!containerName.equals(item.getName())) continue;
            exist = true;
            break;
        }
        if (!exist) {
            throw new IllegalArgumentException("containerName: " + containerName + " is not exists, you need to create them by yourself");
        }
        log.info("containerName: {} has been found", (Object)containerName);
    }
}

