/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import java.util.EnumSet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;

public class ZookeeperTreeCacheListenerAdapter
implements TreeCacheListener {
    private final String watchedPath;
    private final SubscribeListener listener;
    private static final EnumSet<TreeCacheEvent.Type> NODE_CHANGE_EVENTS = EnumSet.of(TreeCacheEvent.Type.NODE_REMOVED, TreeCacheEvent.Type.NODE_UPDATED, TreeCacheEvent.Type.NODE_ADDED);

    public ZookeeperTreeCacheListenerAdapter(String watchedPath, SubscribeListener listener) {
        this.listener = listener;
        this.watchedPath = watchedPath;
    }

    public void childEvent(CuratorFramework curatorFramework, TreeCacheEvent event) {
        if (!this.isNodeChangeEvent(event)) {
            return;
        }
        String eventPath = event.getData().getPath();
        switch (this.listener.getSubscribeScope()) {
            case PATH_ONLY: {
                if (!eventPath.equals(this.watchedPath)) break;
                this.listener.notify(this.convertToEvent(event, this.watchedPath));
                break;
            }
            case CHILDREN_ONLY: {
                if (eventPath.equals(this.watchedPath)) break;
                this.listener.notify(this.convertToEvent(event, this.watchedPath));
                break;
            }
            case ALL: {
                this.listener.notify(this.convertToEvent(event, this.watchedPath));
                break;
            }
            default: {
                throw new RegistryException("Unknown event scope: " + this.listener.getSubscribeScope());
            }
        }
    }

    private boolean isNodeChangeEvent(TreeCacheEvent event) {
        return NODE_CHANGE_EVENTS.contains(event.getType());
    }

    private Event convertToEvent(TreeCacheEvent event, String watchedPath) {
        Event.Type type;
        switch (event.getType()) {
            case NODE_ADDED: {
                type = Event.Type.ADD;
                break;
            }
            case NODE_UPDATED: {
                type = Event.Type.UPDATE;
                break;
            }
            case NODE_REMOVED: {
                type = Event.Type.REMOVE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported event type: " + event.getType());
            }
        }
        ChildData data = event.getData();
        return Event.builder().type(type).watchedPath(watchedPath).eventPath(data.getPath()).eventData(new String(data.getData())).build();
    }
}

