/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;

public class ResponseValidationPolicyBuilder {
    private final List<BiConsumer<HttpResponse, ClientLogger>> assertions = new ArrayList<BiConsumer<HttpResponse, ClientLogger>>();

    public HttpPipelinePolicy build() {
        return new ResponseValidationPolicy(this.assertions);
    }

    public ResponseValidationPolicyBuilder addOptionalEcho(String headerName) {
        this.assertions.add((httpResponse, logger) -> {
            HttpHeaderName httpHeaderName = HttpHeaderName.fromString((String)headerName);
            String requestHeaderValue = httpResponse.getRequest().getHeaders().getValue(httpHeaderName);
            String responseHeaderValue = httpResponse.getHeaders().getValue(httpHeaderName);
            if (responseHeaderValue != null && !responseHeaderValue.equals(requestHeaderValue)) {
                throw logger.logExceptionAsError(new RuntimeException(String.format("Unexpected header value. Expected response to echo `%s: %s`. Got value `%s`.", headerName, requestHeaderValue, responseHeaderValue)));
            }
        });
        return this;
    }

    public static class ResponseValidationPolicy
    implements HttpPipelinePolicy {
        private static final ClientLogger LOGGER = new ClientLogger(ResponseValidationPolicy.class);
        private final List<BiConsumer<HttpResponse, ClientLogger>> assertions;

        ResponseValidationPolicy(List<BiConsumer<HttpResponse, ClientLogger>> assertions) {
            this.assertions = new ArrayList<BiConsumer<HttpResponse, ClientLogger>>(assertions);
        }

        public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
            return next.process().map(response -> {
                this.assertions.forEach(assertion -> assertion.accept(response, LOGGER));
                return response;
            });
        }

        public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
            HttpResponse response = next.processSync();
            this.assertions.forEach(assertion -> assertion.accept(response, LOGGER));
            return response;
        }
    }
}

