/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.resourcemanager.redis.RedisManager;
import com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.azure.resourcemanager.redis.fluent.models.RedisPatchScheduleInner;
import com.azure.resourcemanager.redis.implementation.RedisCacheImpl;
import com.azure.resourcemanager.redis.implementation.RedisPatchScheduleImpl;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.resourcemanager.redis.models.RedisPatchSchedule;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RedisPatchSchedulesImpl
extends ExternalChildResourcesCachedImpl<RedisPatchScheduleImpl, RedisPatchSchedule, RedisPatchScheduleInner, RedisCacheImpl, RedisCache> {
    private static final String PATCH_SCHEDULE_NAME = "default";
    private boolean load = false;

    RedisPatchSchedulesImpl(RedisCacheImpl parent) {
        super((Object)parent, parent.taskGroup(), "PatchSchedule");
    }

    void ensureCollectionLoaded() {
        if (!this.load) {
            this.load = true;
            this.cacheCollection();
        }
    }

    Map<String, RedisPatchSchedule> patchSchedulesAsMap() {
        this.ensureCollectionLoaded();
        HashMap<String, RedisPatchScheduleImpl> result = new HashMap<String, RedisPatchScheduleImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            RedisPatchScheduleImpl patchSchedule = (RedisPatchScheduleImpl)entry.getValue();
            result.put((String)entry.getKey(), patchSchedule);
        }
        return Collections.unmodifiableMap(result);
    }

    public void addPatchSchedule(RedisPatchScheduleImpl patchSchedule) {
        this.ensureCollectionLoaded();
        this.addChildResource(patchSchedule);
    }

    public RedisPatchScheduleImpl getPatchSchedule() {
        this.ensureCollectionLoaded();
        return (RedisPatchScheduleImpl)this.collection().get(PATCH_SCHEDULE_NAME);
    }

    public void removePatchSchedule() {
        this.ensureCollectionLoaded();
        RedisPatchScheduleImpl psch = this.getPatchSchedule();
        if (psch != null) {
            psch.deleteResourceAsync().block();
        }
    }

    public RedisPatchScheduleImpl defineInlinePatchSchedule() {
        this.ensureCollectionLoaded();
        return (RedisPatchScheduleImpl)this.prepareInlineDefine(PATCH_SCHEDULE_NAME);
    }

    public RedisPatchScheduleImpl updateInlinePatchSchedule() {
        this.ensureCollectionLoaded();
        return (RedisPatchScheduleImpl)this.prepareInlineUpdate(PATCH_SCHEDULE_NAME);
    }

    public void deleteInlinePatchSchedule() {
        this.ensureCollectionLoaded();
        this.prepareInlineRemove(PATCH_SCHEDULE_NAME);
    }

    protected Flux<RedisPatchScheduleImpl> listChildResourcesAsync() {
        return ((RedisManagementClient)((RedisManager)((RedisCacheImpl)this.getParent()).manager()).serviceClient()).getPatchSchedules().listByRedisResourceAsync(((RedisCacheImpl)this.getParent()).resourceGroupName(), ((RedisCacheImpl)this.getParent()).name()).map(patchScheduleInner -> new RedisPatchScheduleImpl(patchScheduleInner.name(), (RedisCacheImpl)this.getParent(), (RedisPatchScheduleInner)((Object)patchScheduleInner))).onErrorResume(e -> Mono.empty());
    }

    protected List<RedisPatchScheduleImpl> listChildResources() {
        return (List)this.listChildResourcesAsync().collectList().block();
    }

    protected RedisPatchScheduleImpl newChildResource(String name) {
        return new RedisPatchScheduleImpl(name, (RedisCacheImpl)this.getParent(), new RedisPatchScheduleInner());
    }
}

