/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstanceRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.TenantMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskRelationMapper;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SubWorkflowParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.TaskTimeoutParameter;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.process.WorkflowDag;
import org.apache.dolphinscheduler.service.utils.ClusterConfUtils;
import org.apache.dolphinscheduler.service.utils.DagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessServiceImpl
implements ProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private WorkflowDefinitionLogMapper workflowDefinitionLogMapper;
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private TaskInstanceDao taskInstanceDao;
    @Autowired
    private TaskDefinitionLogDao taskDefinitionLogDao;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private WorkflowInstanceRelationMapper workflowInstanceRelationMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private WorkflowTaskRelationMapper workflowTaskRelationMapper;
    @Autowired
    private WorkflowTaskRelationLogMapper workflowTaskRelationLogMapper;
    @Autowired
    private ClusterMapper clusterMapper;
    @Autowired
    private CuringParamsService curingGlobalParamsService;

    @Override
    public Optional<WorkflowInstance> findWorkflowInstanceDetailById(int workflowInstanceId) {
        return Optional.ofNullable(this.workflowInstanceMapper.queryDetailById(workflowInstanceId));
    }

    @Override
    public WorkflowInstance findWorkflowInstanceById(int workflowInstanceId) {
        return (WorkflowInstance)this.workflowInstanceMapper.selectById((Serializable)Integer.valueOf(workflowInstanceId));
    }

    @Override
    public WorkflowDefinition findWorkflowDefinition(Long workflowDefinitionCode, int workflowDefinitionVersion) {
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByCode(workflowDefinitionCode.longValue());
        if ((workflowDefinition == null || workflowDefinition.getVersion() != workflowDefinitionVersion) && (workflowDefinition = this.workflowDefinitionLogMapper.queryByDefinitionCodeAndVersion(workflowDefinitionCode.longValue(), workflowDefinitionVersion)) != null) {
            workflowDefinition.setId(Integer.valueOf(0));
        }
        return workflowDefinition;
    }

    @Override
    public int deleteWorkflowInstanceById(int workflowInstanceId) {
        return this.workflowInstanceMapper.deleteById((Serializable)Integer.valueOf(workflowInstanceId));
    }

    @Override
    public List<Long> findAllSubWorkflowDefinitionCode(long parentCode) {
        List taskNodeList = this.taskDefinitionDao.getTaskDefinitionListByDefinition(parentCode);
        if (CollectionUtils.isEmpty((Collection)taskNodeList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> subWorkflowDefinitionCodes = new ArrayList<Long>();
        for (TaskDefinition taskNode : taskNodeList) {
            String parameter = taskNode.getTaskParams();
            ObjectNode parameterJson = JSONUtils.parseObject((String)parameter);
            if (parameterJson.get("workflowDefinitionCode") == null) continue;
            SubWorkflowParameters subProcessParam = (SubWorkflowParameters)JSONUtils.parseObject((String)parameter, SubWorkflowParameters.class);
            long subWorkflowDefinitionCode = subProcessParam.getWorkflowDefinitionCode();
            subWorkflowDefinitionCodes.add(subWorkflowDefinitionCode);
            subWorkflowDefinitionCodes.addAll(this.findAllSubWorkflowDefinitionCode(subWorkflowDefinitionCode));
        }
        return subWorkflowDefinitionCodes;
    }

    @Override
    public String getTenantForWorkflow(String tenantCode, int userId) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tenantCode}) && !"default".equals(tenantCode)) {
            return tenantCode;
        }
        if (userId == 0) {
            return null;
        }
        User user = this.userMapper.selectById(userId);
        Tenant tenant = this.tenantMapper.queryById(user.getTenantId());
        return tenant.getTenantCode();
    }

    @Override
    public WorkflowInstance findSubWorkflowInstance(Integer parentWorkflowInstanceId, Integer parentTaskId) {
        WorkflowInstance workflowInstance = null;
        WorkflowInstanceRelation workflowInstanceRelation = this.workflowInstanceRelationMapper.queryByParentId(parentWorkflowInstanceId.intValue(), parentTaskId.intValue());
        if (workflowInstanceRelation == null || workflowInstanceRelation.getWorkflowInstanceId() == 0) {
            return workflowInstance;
        }
        workflowInstance = this.findWorkflowInstanceById(workflowInstanceRelation.getWorkflowInstanceId());
        return workflowInstance;
    }

    @Override
    public WorkflowInstance findParentWorkflowInstance(Integer subWorkflowInstanceId) {
        WorkflowInstance workflowInstance = null;
        WorkflowInstanceRelation workflowInstanceRelation = this.workflowInstanceRelationMapper.queryBySubWorkflowId(subWorkflowInstanceId);
        if (workflowInstanceRelation == null || workflowInstanceRelation.getWorkflowInstanceId() == 0) {
            return workflowInstance;
        }
        workflowInstance = this.findWorkflowInstanceById(workflowInstanceRelation.getParentWorkflowInstanceId());
        return workflowInstance;
    }

    @Override
    public List<Schedule> queryReleaseSchedulerListByWorkflowDefinitionCode(long workflowDefinitionCode) {
        return this.scheduleMapper.queryReleaseSchedulerListByWorkflowDefinitionCode(workflowDefinitionCode);
    }

    @Override
    public DataSource findDataSourceById(int id) {
        return (DataSource)this.dataSourceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public User getUserById(int userId) {
        return this.userMapper.selectById(userId);
    }

    @Override
    public <T> List<T> listUnauthorized(int userId, T[] needChecks, AuthorizationType authorizationType) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (Objects.nonNull(needChecks) && needChecks.length > 0) {
            HashSet<T> originResSet = new HashSet<T>(Arrays.asList(needChecks));
            switch (authorizationType) {
                case DATASOURCE: {
                    Set authorizedDatasources = this.dataSourceMapper.listAuthorizedDataSource(userId, (Object[])needChecks).stream().map(DataSource::getId).collect(Collectors.toSet());
                    originResSet.removeAll(authorizedDatasources);
                    break;
                }
            }
            resultList.addAll(originResSet);
        }
        return resultList;
    }

    @Override
    public int switchVersion(WorkflowDefinition workflowDefinition, WorkflowDefinitionLog workflowDefinitionLog) {
        if (null == workflowDefinition || null == workflowDefinitionLog) {
            return -1;
        }
        workflowDefinitionLog.setId(workflowDefinition.getId());
        workflowDefinitionLog.setReleaseState(ReleaseState.OFFLINE);
        workflowDefinitionLog.setFlag(Flag.YES);
        int result = this.workflowDefinitionMapper.updateById((WorkflowDefinition)workflowDefinitionLog);
        if (result > 0 && (result = this.switchWorkflowTaskRelationVersion((WorkflowDefinition)workflowDefinitionLog)) <= 0) {
            return -1;
        }
        return result;
    }

    @Override
    public int switchWorkflowTaskRelationVersion(WorkflowDefinition workflowDefinition) {
        List workflowTaskRelationListFromLog;
        int batchInsert;
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinition.getCode());
        if (!workflowTaskRelationList.isEmpty()) {
            this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCode(workflowDefinition.getProjectCode(), workflowDefinition.getCode());
        }
        if ((batchInsert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelationListFromLog = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinition.getCode(), workflowDefinition.getVersion()).stream().map(WorkflowTaskRelation::new).collect(Collectors.toList()))) == 0) {
            return -1;
        }
        int result = 0;
        for (WorkflowTaskRelation taskRelation : workflowTaskRelationListFromLog) {
            int switchResult = this.switchTaskDefinitionVersion(taskRelation.getPostTaskCode(), taskRelation.getPostTaskVersion());
            if (switchResult == -1) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int switchTaskDefinitionVersion(long taskCode, int taskVersion) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            return -1;
        }
        if (taskDefinition.getVersion() == taskVersion) {
            return 0;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, taskVersion);
        if (taskDefinitionUpdate == null) {
            return -1;
        }
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        return this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
    }

    @Override
    public int saveTaskDefine(User operator, long projectCode, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        Date now = new Date();
        ArrayList<TaskDefinitionLog> newTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        ArrayList<TaskDefinitionLog> updateTaskDefinitionLogs = new ArrayList<TaskDefinitionLog>();
        for (TaskDefinitionLog taskDefinitionLog2 : taskDefinitionLogs) {
            TaskDefinitionLog definitionCodeAndVersion;
            taskDefinitionLog2.setProjectCode(projectCode);
            taskDefinitionLog2.setUpdateTime(now);
            taskDefinitionLog2.setOperateTime(now);
            taskDefinitionLog2.setOperator(operator.getId().intValue());
            if (taskDefinitionLog2.getCode() == 0L) {
                taskDefinitionLog2.setCode(CodeGenerateUtils.genCode());
            }
            if (taskDefinitionLog2.getVersion() == 0) {
                taskDefinitionLog2.setVersion(1);
            }
            if ((definitionCodeAndVersion = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskDefinitionLog2.getCode(), taskDefinitionLog2.getVersion())) == null) {
                taskDefinitionLog2.setUserId(operator.getId().intValue());
                taskDefinitionLog2.setCreateTime(now);
                newTaskDefinitionLogs.add(taskDefinitionLog2);
                continue;
            }
            if (taskDefinitionLog2.equals((Object)definitionCodeAndVersion)) continue;
            taskDefinitionLog2.setUserId(definitionCodeAndVersion.getUserId());
            Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionLog2.getCode());
            taskDefinitionLog2.setVersion(version + 1);
            taskDefinitionLog2.setCreateTime(definitionCodeAndVersion.getCreateTime());
            updateTaskDefinitionLogs.add(taskDefinitionLog2);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs)) {
            List taskDefinitionCodes = updateTaskDefinitionLogs.stream().map(TaskDefinition::getCode).distinct().collect(Collectors.toList());
            Map taskDefinitionMap = this.taskDefinitionMapper.queryByCodeList(taskDefinitionCodes).stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity()));
            for (TaskDefinitionLog taskDefinitionToUpdate : updateTaskDefinitionLogs) {
                TaskDefinition task = (TaskDefinition)taskDefinitionMap.get(taskDefinitionToUpdate.getCode());
                if (task == null) {
                    newTaskDefinitionLogs.add(taskDefinitionToUpdate);
                    continue;
                }
                taskDefinitionToUpdate.setId(task.getId());
            }
        }
        int updateResult = 0;
        int insertResult = 0;
        List newInsertTaskDefinitionLogs = newTaskDefinitionLogs.stream().filter(taskDefinitionLog -> !updateTaskDefinitionLogs.contains(taskDefinitionLog)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newInsertTaskDefinitionLogs)) {
            insertResult = this.taskDefinitionLogMapper.batchInsert(newInsertTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs)) {
            insertResult += this.taskDefinitionLogMapper.batchInsert(updateTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(newTaskDefinitionLogs) && Boolean.TRUE.equals(syncDefine)) {
            updateResult += this.taskDefinitionMapper.batchInsert(newTaskDefinitionLogs);
        }
        if (CollectionUtils.isNotEmpty(updateTaskDefinitionLogs) && Boolean.TRUE.equals(syncDefine)) {
            for (TaskDefinitionLog taskDefinitionLog3 : updateTaskDefinitionLogs) {
                updateResult += this.taskDefinitionMapper.updateById((Object)taskDefinitionLog3);
            }
        }
        return (insertResult & updateResult) > 0 ? 1 : 0;
    }

    @Override
    public int saveWorkflowDefine(User operator, WorkflowDefinition workflowDefinition, Boolean syncDefine, Boolean isFromWorkflowDefinition) {
        WorkflowDefinitionLog workflowDefinitionLog = new WorkflowDefinitionLog(workflowDefinition);
        Integer version = this.workflowDefinitionLogMapper.queryMaxVersionForDefinition(workflowDefinition.getCode());
        int insertVersion = version == null || version == 0 ? 1 : version + 1;
        workflowDefinitionLog.setVersion(insertVersion);
        workflowDefinitionLog.setReleaseState(isFromWorkflowDefinition == false || workflowDefinitionLog.getReleaseState() == ReleaseState.ONLINE ? ReleaseState.ONLINE : ReleaseState.OFFLINE);
        workflowDefinitionLog.setOperator(operator.getId().intValue());
        workflowDefinitionLog.setOperateTime(workflowDefinition.getUpdateTime());
        workflowDefinitionLog.setId(null);
        int insertLog = this.workflowDefinitionLogMapper.insert((Object)workflowDefinitionLog);
        int result = 1;
        if (Boolean.TRUE.equals(syncDefine)) {
            if (workflowDefinition.getId() == null) {
                result = this.workflowDefinitionMapper.insert((Object)workflowDefinitionLog);
                workflowDefinition.setId(workflowDefinitionLog.getId());
            } else {
                workflowDefinitionLog.setId(workflowDefinition.getId());
                result = this.workflowDefinitionMapper.updateById((WorkflowDefinition)workflowDefinitionLog);
            }
        }
        return (insertLog & result) > 0 ? insertVersion : 0;
    }

    @Override
    public int saveTaskRelation(User operator, long projectCode, long workflowDefinitionCode, int workflowDefinitionVersion, List<WorkflowTaskRelationLog> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs, Boolean syncDefine) {
        int resultLog;
        if (taskRelationList.isEmpty()) {
            return 0;
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = null;
        if (CollectionUtils.isNotEmpty(taskDefinitionLogs)) {
            taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        }
        Date now = new Date();
        for (WorkflowTaskRelationLog workflowTaskRelationLog : taskRelationList) {
            workflowTaskRelationLog.setProjectCode(projectCode);
            workflowTaskRelationLog.setWorkflowDefinitionCode(workflowDefinitionCode);
            workflowTaskRelationLog.setWorkflowDefinitionVersion(workflowDefinitionVersion);
            if (taskDefinitionLogMap != null) {
                TaskDefinitionLog postTaskDefinitionLog;
                TaskDefinitionLog preTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPreTaskCode());
                if (preTaskDefinitionLog != null) {
                    workflowTaskRelationLog.setPreTaskVersion(preTaskDefinitionLog.getVersion());
                }
                if ((postTaskDefinitionLog = taskDefinitionLogMap.get(workflowTaskRelationLog.getPostTaskCode())) != null) {
                    workflowTaskRelationLog.setPostTaskVersion(postTaskDefinitionLog.getVersion());
                }
            }
            workflowTaskRelationLog.setCreateTime(now);
            workflowTaskRelationLog.setUpdateTime(now);
            workflowTaskRelationLog.setOperator(operator.getId().intValue());
            workflowTaskRelationLog.setOperateTime(now);
        }
        int insert = taskRelationList.size();
        if (Boolean.TRUE.equals(syncDefine)) {
            List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByWorkflowDefinitionCode(workflowDefinitionCode);
            if (!workflowTaskRelationList.isEmpty()) {
                Set taskRelationSet;
                Set workflowTaskRelationSet = workflowTaskRelationList.stream().map(WorkflowTaskRelation::hashCode).collect(Collectors.toSet());
                boolean result = CollectionUtils.isEqualCollection(workflowTaskRelationSet, taskRelationSet = taskRelationList.stream().map(WorkflowTaskRelationLog::hashCode).collect(Collectors.toSet()));
                if (result) {
                    return 0;
                }
                this.workflowTaskRelationMapper.deleteByWorkflowDefinitionCode(projectCode, workflowDefinitionCode);
            }
            List workflowTaskRelations = taskRelationList.stream().map(WorkflowTaskRelation::new).collect(Collectors.toList());
            insert = this.workflowTaskRelationMapper.batchInsert(workflowTaskRelations);
        }
        return (insert & (resultLog = this.workflowTaskRelationLogMapper.batchInsert(taskRelationList))) > 0 ? 0 : -1;
    }

    @Override
    public boolean isTaskOnline(long taskCode) {
        List workflowTaskRelationList = this.workflowTaskRelationMapper.queryByTaskCode(taskCode);
        if (!workflowTaskRelationList.isEmpty()) {
            Set processDefinitionCodes = workflowTaskRelationList.stream().map(WorkflowTaskRelation::getWorkflowDefinitionCode).collect(Collectors.toSet());
            List workflowDefinitionList = this.workflowDefinitionMapper.queryByCodes(processDefinitionCodes);
            for (WorkflowDefinition workflowDefinition : workflowDefinitionList) {
                if (workflowDefinition.getReleaseState() != ReleaseState.ONLINE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DAG<Long, TaskNode, TaskNodeRelation> genDagGraph(WorkflowDefinition workflowDefinition) {
        List<WorkflowTaskRelation> taskRelations = this.findRelationByCode(workflowDefinition.getCode(), workflowDefinition.getVersion());
        List<TaskNode> taskNodeList = this.transformTask(taskRelations, Lists.newArrayList());
        WorkflowDag workflowDag = DagHelper.getWorkflowDag(taskNodeList, new ArrayList<WorkflowTaskRelation>(taskRelations));
        return DagHelper.buildDagGraph(workflowDag);
    }

    @Override
    public DagData genDagData(WorkflowDefinition workflowDefinition) {
        List<WorkflowTaskRelation> taskRelations = this.findRelationByCode(workflowDefinition.getCode(), workflowDefinition.getVersion());
        List taskDefinitions = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelations).stream().map(t -> t).collect(Collectors.toList());
        return new DagData(workflowDefinition, taskRelations, taskDefinitions);
    }

    @Override
    public List<WorkflowTaskRelation> findRelationByCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        List workflowTaskRelationLogList = this.workflowTaskRelationLogMapper.queryByWorkflowCodeAndVersion(workflowDefinitionCode, workflowDefinitionVersion);
        return workflowTaskRelationLogList.stream().map(r -> r).collect(Collectors.toList());
    }

    @Override
    public List<TaskNode> transformTask(List<WorkflowTaskRelation> taskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        HashMap<Long, List> taskCodeMap = new HashMap<Long, List>();
        for (WorkflowTaskRelation workflowTaskRelation : taskRelationList) {
            taskCodeMap.compute(workflowTaskRelation.getPostTaskCode(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Long>();
                }
                if (workflowTaskRelation.getPreTaskCode() != 0L) {
                    v.add(workflowTaskRelation.getPreTaskCode());
                }
                return v;
            });
        }
        if (CollectionUtils.isEmpty(taskDefinitionLogs)) {
            taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelationList);
        }
        Map<Long, TaskDefinitionLog> taskDefinitionLogMap = taskDefinitionLogs.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinitionLog -> taskDefinitionLog));
        ArrayList<TaskNode> taskNodeList = new ArrayList<TaskNode>();
        for (Map.Entry code : taskCodeMap.entrySet()) {
            TaskDefinitionLog taskDefinitionLog2 = taskDefinitionLogMap.get(code.getKey());
            if (taskDefinitionLog2 == null) continue;
            TaskNode taskNode = new TaskNode();
            taskNode.setCode(taskDefinitionLog2.getCode());
            taskNode.setVersion(taskDefinitionLog2.getVersion());
            taskNode.setName(taskDefinitionLog2.getName());
            taskNode.setDesc(taskDefinitionLog2.getDescription());
            taskNode.setType(taskDefinitionLog2.getTaskType().toUpperCase());
            taskNode.setRunFlag(taskDefinitionLog2.getFlag() == Flag.YES ? "NORMAL" : "FORBIDDEN");
            taskNode.setMaxRetryTimes(taskDefinitionLog2.getFailRetryTimes());
            taskNode.setRetryInterval(taskDefinitionLog2.getFailRetryInterval());
            taskNode.setParams(taskDefinitionLog2.getTaskParams());
            taskNode.setTaskInstancePriority(taskDefinitionLog2.getTaskPriority());
            taskNode.setWorkerGroup(taskDefinitionLog2.getWorkerGroup());
            taskNode.setEnvironmentCode(taskDefinitionLog2.getEnvironmentCode());
            taskNode.setTimeout(JSONUtils.toJsonString((Object)new TaskTimeoutParameter(taskDefinitionLog2.getTimeoutFlag() == TimeoutFlag.OPEN, taskDefinitionLog2.getTimeoutNotifyStrategy(), taskDefinitionLog2.getTimeout())));
            taskNode.setDelayTime(taskDefinitionLog2.getDelayTime());
            taskNode.setPreTasks(JSONUtils.toJsonString(((List)code.getValue()).stream().map(taskDefinitionLogMap::get).map(TaskDefinition::getCode).collect(Collectors.toList())));
            taskNode.setTaskGroupId(taskDefinitionLog2.getTaskGroupId());
            taskNode.setTaskGroupPriority(taskDefinitionLog2.getTaskGroupPriority());
            taskNode.setCpuQuota(taskDefinitionLog2.getCpuQuota());
            taskNode.setMemoryMax(taskDefinitionLog2.getMemoryMax());
            taskNode.setTaskExecuteType(taskDefinitionLog2.getTaskExecuteType());
            taskNodeList.add(taskNode);
        }
        return taskNodeList;
    }

    @Override
    public String findConfigYamlByName(String clusterName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            return null;
        }
        QueryWrapper nodeWrapper = new QueryWrapper();
        nodeWrapper.eq((Object)"name", (Object)clusterName);
        Cluster cluster = (Cluster)this.clusterMapper.selectOne((Wrapper)nodeWrapper);
        return cluster == null ? null : ClusterConfUtils.getK8sConfig(cluster.getConfig());
    }

    @Override
    public void forceWorkflowInstanceSuccessByTaskInstanceId(TaskInstance task) {
        List failTaskList;
        List<WorkflowTaskRelation> taskRelations;
        List taskDefinitionLogs;
        List definiteTaskCodeList;
        List validTaskList;
        List instanceTaskCodeList;
        WorkflowInstance workflowInstance = this.findWorkflowInstanceDetailById(task.getWorkflowInstanceId()).orElse(null);
        if (workflowInstance != null && (workflowInstance.getState().isFailure() || workflowInstance.getState().isStopped()) && CollectionUtils.isEqualCollection(instanceTaskCodeList = (validTaskList = this.taskInstanceDao.queryValidTaskListByWorkflowInstanceId(workflowInstance.getId())).stream().map(TaskInstance::getTaskCode).collect(Collectors.toList()), definiteTaskCodeList = (taskDefinitionLogs = this.taskDefinitionLogDao.queryTaskDefineLogList(taskRelations = this.findRelationByCode(workflowInstance.getWorkflowDefinitionCode(), workflowInstance.getWorkflowDefinitionVersion()))).stream().filter(definitionLog -> definitionLog.getFlag() == Flag.YES).map(TaskDefinition::getCode).collect(Collectors.toList())) && (failTaskList = validTaskList.stream().filter(instance -> instance.getState().isFailure() || instance.getState().isKill()).map(TaskInstance::getId).collect(Collectors.toList())).size() == 1 && failTaskList.contains(task.getId())) {
            workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUCCESS, "success by task force success");
            this.workflowInstanceDao.updateById((Object)workflowInstance);
        }
    }
}

