/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import java.util.logging.Logger;
import net.spy.memcached.compat.log.AbstractLogger;
import net.spy.memcached.compat.log.Level;

public class SunLogger
extends AbstractLogger {
    private final Logger sunLogger;

    public SunLogger(String name) {
        super(name);
        this.sunLogger = Logger.getLogger(name);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.sunLogger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.sunLogger.isLoggable(java.util.logging.Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.sunLogger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public void log(Level level, Object message, Throwable e) {
        java.util.logging.Level sLevel = java.util.logging.Level.SEVERE;
        switch (level == null ? Level.FATAL : level) {
            case TRACE: {
                sLevel = java.util.logging.Level.FINEST;
                break;
            }
            case DEBUG: {
                sLevel = java.util.logging.Level.FINE;
                break;
            }
            case INFO: {
                sLevel = java.util.logging.Level.INFO;
                break;
            }
            case WARN: {
                sLevel = java.util.logging.Level.WARNING;
                break;
            }
            case ERROR: {
                sLevel = java.util.logging.Level.SEVERE;
                break;
            }
            case FATAL: {
                sLevel = java.util.logging.Level.SEVERE;
                break;
            }
            default: {
                sLevel = java.util.logging.Level.SEVERE;
                this.sunLogger.log(sLevel, "Unhandled log level:  " + (Object)((Object)level) + " for the following message");
            }
        }
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        StackTraceElement logRequestor = null;
        String alclass = AbstractLogger.class.getName();
        for (int i = 0; i < ste.length && logRequestor == null; ++i) {
            if (!ste[i].getClassName().equals(alclass) || i + 1 >= ste.length || !(logRequestor = ste[i + 1]).getClassName().equals(alclass)) continue;
            logRequestor = null;
        }
        if (logRequestor != null) {
            if (e != null) {
                this.sunLogger.logp(sLevel, logRequestor.getClassName(), logRequestor.getMethodName(), message.toString(), e);
            } else {
                this.sunLogger.logp(sLevel, logRequestor.getClassName(), logRequestor.getMethodName(), message.toString());
            }
        } else if (e != null) {
            this.sunLogger.log(sLevel, message.toString(), e);
        } else {
            this.sunLogger.log(sLevel, message.toString());
        }
    }
}

