/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.joda.time.Interval;

public class SpecificSegmentLockRequest
implements LockRequest {
    private final TaskLockType lockType;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    private final int partitionId;
    private final String version;
    private final int priority;
    private final boolean revoked;

    public SpecificSegmentLockRequest(TaskLockType lockType, String groupId, String dataSource, Interval interval, String version, int partitionId, int priority, boolean revoked) {
        this.lockType = lockType;
        this.groupId = groupId;
        this.dataSource = dataSource;
        this.interval = interval;
        this.version = version;
        this.partitionId = partitionId;
        this.priority = priority;
        this.revoked = revoked;
    }

    public SpecificSegmentLockRequest(TaskLockType lockType, Task task, Interval interval, String version, int partitionId) {
        this(lockType, task.getGroupId(), task.getDataSource(), interval, version, partitionId, task.getPriority(), false);
    }

    public SpecificSegmentLockRequest(LockRequestForNewSegment request, SegmentIdWithShardSpec newId) {
        this(request.getType(), request.getGroupId(), newId.getDataSource(), newId.getInterval(), newId.getVersion(), newId.getShardSpec().getPartitionNum(), request.getPriority(), request.isRevoked());
    }

    @Override
    public LockGranularity getGranularity() {
        return LockGranularity.SEGMENT;
    }

    @Override
    public TaskLockType getType() {
        return this.lockType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean isRevoked() {
        return this.revoked;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public TaskLock toLock() {
        return new SegmentLock(this.lockType, this.groupId, this.dataSource, this.interval, this.version, this.partitionId, this.priority, this.revoked);
    }

    public String toString() {
        return "SpecificSegmentLockRequest{lockType=" + String.valueOf((Object)this.lockType) + ", groupId='" + this.groupId + "', dataSource='" + this.dataSource + "', interval=" + String.valueOf(this.interval) + ", partitionId=" + this.partitionId + ", version='" + this.version + "', priority=" + this.priority + ", revoked=" + this.revoked + "}";
    }
}

