/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.guice;

import com.google.inject.Binder;
import com.google.inject.Provides;
import java.nio.ByteBuffer;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.guice.DartWorkerConfig;
import org.apache.druid.msq.dart.worker.DartProcessingBuffersProvider;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.MemoryIntrospectorImpl;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.utils.RuntimeInfo;

@LoadScope(roles={"historical"})
public class DartWorkerMemoryManagementModule
implements DruidModule {
    public void configure(Binder binder) {
    }

    @Provides
    public MemoryIntrospector createMemoryIntrospector(DartWorkerConfig workerConfig, DruidProcessingConfig druidProcessingConfig, RuntimeInfo runtimeInfo) {
        return new MemoryIntrospectorImpl(runtimeInfo.getMaxHeapSizeBytes(), workerConfig.getHeapFraction(), DartWorkerMemoryManagementModule.computeConcurrentQueries(workerConfig, druidProcessingConfig), druidProcessingConfig.getNumThreads(), null);
    }

    @Provides
    @Dart
    @LazySingleton
    public ProcessingBuffersProvider createProcessingBuffersProvider(@Merging BlockingPool<ByteBuffer> mergeBufferPool, DruidProcessingConfig processingConfig) {
        return new DartProcessingBuffersProvider(mergeBufferPool, processingConfig.getNumThreads());
    }

    private static int computeConcurrentQueries(DartWorkerConfig workerConfig, DruidProcessingConfig processingConfig) {
        if (workerConfig.getConcurrentQueries() == -1) {
            return processingConfig.getNumMergeBuffers();
        }
        if (workerConfig.getConcurrentQueries() < 0) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("concurrentQueries[%s] must be positive or -1", new Object[]{workerConfig.getConcurrentQueries()});
        }
        if (workerConfig.getConcurrentQueries() > processingConfig.getNumMergeBuffers()) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("concurrentQueries[%s] must be less than numMergeBuffers[%s]", new Object[]{workerConfig.getConcurrentQueries(), processingConfig.getNumMergeBuffers()});
        }
        return workerConfig.getConcurrentQueries();
    }
}

