/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.WorkerImpl;
import org.apache.druid.msq.exec.WorkerRunRef;
import org.apache.druid.msq.indexing.IndexerWorkerContext;
import org.apache.druid.msq.indexing.PeriodicControllerChecker;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;
import org.apache.druid.server.security.ResourceAction;

@JsonTypeName(value="query_worker")
public class MSQWorkerTask
extends AbstractTask {
    public static final String TYPE = "query_worker";
    private final String controllerTaskId;
    private final int workerNumber;
    private final int retryCount;
    private final WorkerRunRef workerRunRef = new WorkerRunRef();
    @JacksonInject
    private Injector injector;

    @JsonCreator
    @VisibleForTesting
    public MSQWorkerTask(@JsonProperty(value="controllerTaskId") String controllerTaskId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="retry", defaultValue="0") int retryCount) {
        super(MSQTasks.workerTaskId(controllerTaskId, workerNumber, retryCount), controllerTaskId, null, dataSource, context);
        this.controllerTaskId = controllerTaskId;
        this.workerNumber = workerNumber;
        this.retryCount = retryCount;
    }

    @JsonProperty
    public String getControllerTaskId() {
        return this.controllerTaskId;
    }

    @JsonProperty
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @JsonProperty(value="retry")
    public int getRetryCount() {
        return this.retryCount;
    }

    public MSQWorkerTask getRetryTask() {
        return new MSQWorkerTask(this.controllerTaskId, this.getDataSource(), this.workerNumber, this.getContext(), this.retryCount + 1);
    }

    public String getType() {
        return TYPE;
    }

    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    public boolean isReady(TaskActionClient taskActionClient) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public TaskStatus runTask(TaskToolbox toolbox) {
        this.emitMetric(toolbox.getEmitter(), "ingest/count", 1);
        try (IndexerWorkerContext context = IndexerWorkerContext.createProductionInstance(this, toolbox, this.injector);){
            TaskStatus taskStatus;
            ListeningExecutorService workerExec = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)("query-worker[" + StringUtils.encodeForFormat((String)this.getId()) + "]-%s")));
            try {
                WorkerImpl worker = new WorkerImpl(this, context);
                ListenableFuture<?> future = this.workerRunRef.run(worker, workerExec);
                try (PeriodicControllerChecker ignored = this.openControllerChecker(context);){
                    FutureUtils.getUnchecked(future, (boolean)true);
                }
                taskStatus = TaskStatus.success((String)this.getId());
            }
            catch (Throwable throwable) {
                workerExec.shutdown();
                throw throwable;
            }
            workerExec.shutdown();
            return taskStatus;
        }
        catch (MSQException e) {
            return TaskStatus.failure((String)this.getId(), (String)MSQFaultUtils.generateMessageWithErrorCode(e.getFault()));
        }
    }

    public void stopGracefully(TaskConfig taskConfig) {
        this.workerRunRef.cancel();
    }

    public int getPriority() {
        return (Integer)this.getContextValue("priority", 50);
    }

    public boolean supportsQueries() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MSQWorkerTask that = (MSQWorkerTask)((Object)o);
        return this.workerNumber == that.workerNumber && this.retryCount == that.retryCount && Objects.equals(this.controllerTaskId, that.controllerTaskId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.controllerTaskId, this.workerNumber, this.retryCount);
    }

    private PeriodicControllerChecker openControllerChecker(IndexerWorkerContext context) {
        return PeriodicControllerChecker.open(this.getControllerTaskId(), this.getId(), context.controllerLocator(), this.workerRunRef::cancel);
    }
}

