/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;

public class PeriodicControllerChecker
implements Closeable {
    private static final Logger log = new Logger(PeriodicControllerChecker.class);
    private static final long FREQUENCY_CHECK_MILLIS = 1000L;
    private static final long FREQUENCY_CHECK_JITTER = 30L;
    private final String controllerId;
    private final String workerId;
    private final ServiceLocator controllerLocator;
    private final Runnable workerCanceler;
    private final ExecutorService exec;

    public PeriodicControllerChecker(String controllerId, String workerId, ServiceLocator controllerLocator, Runnable workerCanceler, ExecutorService exec) {
        this.controllerId = controllerId;
        this.workerId = workerId;
        this.controllerLocator = controllerLocator;
        this.workerCanceler = workerCanceler;
        this.exec = exec;
    }

    public static PeriodicControllerChecker open(String controllerId, String workerId, ServiceLocator controllerLocator, Runnable workerCanceler) {
        PeriodicControllerChecker checker = new PeriodicControllerChecker(controllerId, workerId, controllerLocator, workerCanceler, Execs.singleThreaded((String)("controller-status-checker[" + StringUtils.encodeForFormat((String)controllerId) + "]-%d")));
        checker.start();
        return checker;
    }

    void start() {
        this.exec.submit(this::controllerCheckerRunnable);
    }

    void controllerCheckerRunnable() {
        try {
            while (true) {
                long sleepTimeMillis = 1000L + ThreadLocalRandom.current().nextLong(-30L, 60L);
                ServiceLocations controllerLocations = (ServiceLocations)this.controllerLocator.locate().get();
                if (controllerLocations.isClosed()) {
                    log.warn("Controller[%s] no longer exists. Worker[%s] will exit.", new Object[]{this.controllerId, this.workerId});
                    break;
                }
                Thread.sleep(sleepTimeMillis);
            }
        }
        catch (InterruptedException ignored) {
            return;
        }
        catch (Throwable e) {
            log.warn(e, "Periodic fetch of controller[%s] location encountered an exception. Worker[%s] will exit.", new Object[]{this.controllerId, this.workerId});
        }
        try {
            this.workerCanceler.run();
        }
        catch (Throwable e) {
            log.warn(e, "Failed to cancel worker[%s]", new Object[]{this.workerId});
        }
    }

    @Override
    public void close() {
        this.exec.shutdownNow();
    }
}

