/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.destination;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.util.ArrayIngestMode;
import org.apache.druid.msq.util.DimensionSchemaUtils;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.msq.util.PassthroughAggregatorFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.utils.CollectionUtils;

public final class SegmentGenerationUtils {
    private static final Logger log = new Logger(SegmentGenerationUtils.class);

    public static DataSchema makeDataSchemaForIngestion(MSQSpec querySpec, RowSignature querySignature, ClusterBy queryClusterBy, ColumnMappings columnMappings, ObjectMapper jsonMapper, Query<?> query) {
        DataSourceMSQDestination destination = (DataSourceMSQDestination)querySpec.getDestination();
        boolean isRollupQuery = SegmentGenerationUtils.isRollupQuery(query);
        boolean forceSegmentSortByTime = MultiStageQueryContext.isForceSegmentSortByTime(querySpec.getContext());
        NonnullPair<DimensionsSpec, List<AggregatorFactory>> dimensionsAndAggregators = SegmentGenerationUtils.makeDimensionsAndAggregatorsForIngestion(querySignature, queryClusterBy, destination.getSegmentSortOrder(), forceSegmentSortByTime, columnMappings, isRollupQuery, query, destination.getDimensionSchemas());
        return DataSchema.builder().withDataSource(destination.getDataSource()).withTimestamp(new TimestampSpec("__time", "millis", null)).withDimensions((DimensionsSpec)dimensionsAndAggregators.lhs).withAggregators(((List)dimensionsAndAggregators.rhs).toArray(new AggregatorFactory[0])).withGranularity(SegmentGenerationUtils.makeGranularitySpecForIngestion(query, querySpec.getColumnMappings(), isRollupQuery, jsonMapper)).withProjections(destination.getProjections()).build();
    }

    private static GranularitySpec makeGranularitySpecForIngestion(Query<?> query, ColumnMappings columnMappings, boolean isRollupQuery, ObjectMapper jsonMapper) {
        if (isRollupQuery) {
            String queryGranularityString = query.context().getString("timestampResultFieldGranularity", "");
            if (SegmentGenerationUtils.timeIsGroupByDimension((GroupByQuery)query, columnMappings) && !queryGranularityString.isEmpty()) {
                Granularity queryGranularity;
                try {
                    queryGranularity = (Granularity)jsonMapper.readValue(queryGranularityString, Granularity.class);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                return new ArbitraryGranularitySpec(queryGranularity, Boolean.valueOf(true), (List)Intervals.ONLY_ETERNITY);
            }
            return new ArbitraryGranularitySpec(Granularities.NONE, Boolean.valueOf(true), (List)Intervals.ONLY_ETERNITY);
        }
        return new ArbitraryGranularitySpec(Granularities.NONE, Boolean.valueOf(false), (List)Intervals.ONLY_ETERNITY);
    }

    private static boolean timeIsGroupByDimension(GroupByQuery groupByQuery, ColumnMappings columnMappings) {
        IntList positions = columnMappings.getOutputColumnsByName("__time");
        if (positions.size() == 1) {
            String queryTimeColumn = columnMappings.getQueryColumnName(positions.getInt(0));
            return queryTimeColumn.equals(groupByQuery.context().getString("timestampResultField"));
        }
        return false;
    }

    private static boolean isRollupQuery(Query<?> query) {
        return query instanceof GroupByQuery && !MultiStageQueryContext.isFinalizeAggregations(query.context()) && !query.context().getBoolean("groupByEnableMultiValueUnnesting", true);
    }

    private static DimensionSchema getDimensionSchema(String outputColumnName, @Nullable ColumnType queryType, QueryContext context, @Nullable Map<String, DimensionSchema> dimensionSchemas) {
        if (dimensionSchemas != null && dimensionSchemas.containsKey(outputColumnName)) {
            return dimensionSchemas.get(outputColumnName);
        }
        return DimensionSchemaUtils.createDimensionSchema(outputColumnName, queryType, MultiStageQueryContext.useAutoColumnSchemas(context), MultiStageQueryContext.getArrayIngestMode(context));
    }

    private static NonnullPair<DimensionsSpec, List<AggregatorFactory>> makeDimensionsAndAggregatorsForIngestion(RowSignature querySignature, ClusterBy queryClusterBy, List<String> contextSegmentSortOrder, boolean forceSegmentSortByTime, ColumnMappings columnMappings, boolean isRollupQuery, Query<?> query, @Nullable Map<String, DimensionSchema> dimensionSchemas) {
        int outputColumn;
        IntListIterator intListIterator;
        if (MultiStageQueryContext.getArrayIngestMode(query.context()) == ArrayIngestMode.MVD) {
            log.warn("%s[mvd] is active for this task. This causes string arrays (VARCHAR ARRAY in SQL) to be ingested as multi-value strings rather than true arrays. This behavior may change in a future version of Druid. To be compatible with future behavior changes, we recommend setting %s to[array], which creates a clearer separation between multi-value strings and true arrays. In either[mvd] or[array] mode, you can write out multi-value string dimensions using ARRAY_TO_MV. See https://druid.apache.org/docs/latest/querying/arrays#arrayingestmode for more details.", new Object[]{"arrayIngestMode", "arrayIngestMode"});
        }
        ArrayList<DimensionSchema> dimensions = new ArrayList<DimensionSchema>();
        ArrayList<AggregatorFactory> aggregators = new ArrayList<AggregatorFactory>();
        LinkedHashSet<String> outputColumnsInOrder = new LinkedHashSet<String>(contextSegmentSortOrder);
        if (columnMappings.hasOutputColumn("__time") && forceSegmentSortByTime) {
            outputColumnsInOrder.add("__time");
        }
        for (Object clusterByColumn : queryClusterBy.getColumns()) {
            IntList outputColumns = columnMappings.getOutputColumnsForQueryColumn(clusterByColumn.columnName());
            intListIterator = outputColumns.iterator();
            while (intListIterator.hasNext()) {
                outputColumn = (Integer)intListIterator.next();
                outputColumnsInOrder.add(columnMappings.getOutputColumnName(outputColumn));
            }
        }
        outputColumnsInOrder.addAll(columnMappings.getOutputColumnNames());
        HashMap<String, AggregatorFactory> outputColumnAggregatorFactories = new HashMap<String, AggregatorFactory>();
        if (isRollupQuery) {
            for (AggregatorFactory aggregatorFactory : ((GroupByQuery)query).getAggregatorSpecs()) {
                intListIterator = columnMappings.getOutputColumnsForQueryColumn(aggregatorFactory.getName()).iterator();
                while (intListIterator.hasNext()) {
                    outputColumn = (Integer)intListIterator.next();
                    String outputColumnName = columnMappings.getOutputColumnName(outputColumn);
                    if (outputColumnAggregatorFactories.containsKey(outputColumnName)) {
                        throw new ISE("There can only be one aggregation for column [%s].", new Object[]{outputColumn});
                    }
                    outputColumnAggregatorFactories.put(outputColumnName, aggregatorFactory.withName(outputColumnName).getCombiningFactory());
                }
            }
        }
        for (String outputColumnName : outputColumnsInOrder) {
            int outputColumn2 = (Integer)CollectionUtils.getOnlyElement((Iterable)columnMappings.getOutputColumnsByName(outputColumnName), xs -> new ISE("Expected single output column for name [%s], but got [%s]", new Object[]{outputColumnName, xs}));
            String queryColumn = columnMappings.getQueryColumnName(outputColumn2);
            ColumnType type = (ColumnType)querySignature.getColumnType(queryColumn).orElseThrow(() -> new ISE("No type for column [%s]", new Object[]{outputColumnName}));
            if (!type.is((TypeDescriptor)ValueType.COMPLEX)) {
                SegmentGenerationUtils.populateDimensionsAndAggregators(dimensions, aggregators, outputColumnAggregatorFactories, outputColumnName, type, query.context(), dimensionSchemas);
                continue;
            }
            if (DimensionHandlerUtils.DIMENSION_HANDLER_PROVIDERS.containsKey(type.getComplexTypeName())) {
                dimensions.add(SegmentGenerationUtils.getDimensionSchema(outputColumnName, type, query.context(), dimensionSchemas));
                continue;
            }
            if (!isRollupQuery) {
                aggregators.add(new PassthroughAggregatorFactory(outputColumnName, type.getComplexTypeName()));
                continue;
            }
            SegmentGenerationUtils.populateDimensionsAndAggregators(dimensions, aggregators, outputColumnAggregatorFactories, outputColumnName, type, query.context(), dimensionSchemas);
        }
        DimensionsSpec.Builder dimensionsSpecBuilder = DimensionsSpec.builder();
        if (!dimensions.isEmpty() && ((DimensionSchema)dimensions.get(0)).getName().equals("__time")) {
            dimensions.remove(0);
            dimensionsSpecBuilder.setForceSegmentSortByTime(null);
        } else {
            dimensionsSpecBuilder.setForceSegmentSortByTime(forceSegmentSortByTime ? null : Boolean.valueOf(false));
        }
        return new NonnullPair((Object)dimensionsSpecBuilder.setDimensions(dimensions).build(), aggregators);
    }

    private static void populateDimensionsAndAggregators(List<DimensionSchema> dimensions, List<AggregatorFactory> aggregators, Map<String, AggregatorFactory> outputColumnAggregatorFactories, String outputColumn, ColumnType type, QueryContext context, Map<String, DimensionSchema> dimensionSchemas) {
        if ("__time".equals(outputColumn)) {
            if (!type.is((TypeDescriptor)ValueType.LONG)) {
                throw DruidException.defensive((String)"Incorrect type[%s] for column[%s]", (Object[])new Object[]{type, outputColumn});
            }
            dimensions.add((DimensionSchema)new LongDimensionSchema(outputColumn));
        } else if (outputColumnAggregatorFactories.containsKey(outputColumn)) {
            aggregators.add(outputColumnAggregatorFactories.get(outputColumn));
        } else {
            dimensions.add(SegmentGenerationUtils.getDimensionSchema(outputColumn, type, context, dimensionSchemas));
        }
    }

    private SegmentGenerationUtils() {
    }
}

