/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.joda.time.DateTime;

@JsonTypeName(value="TooManySegmentsInTimeChunk")
public class TooManySegmentsInTimeChunkFault
extends BaseMSQFault {
    public static final String CODE = "TooManySegmentsInTimeChunk";
    private final DateTime timeChunk;
    private final int numSegments;
    private final int maxNumSegments;
    private final Granularity segmentGranularity;

    @JsonCreator
    public TooManySegmentsInTimeChunkFault(@JsonProperty(value="timeChunk") DateTime timeChunk, @JsonProperty(value="numSegments") int numSegments, @JsonProperty(value="maxNumSegments") int maxNumSegments, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity) {
        super(CODE, "Too many segments requested to be generated in time chunk[%s] with granularity[%s] (requested = [%,d], maximum = [%,d]). Please try breaking up your query or change the maximum using the query context parameter[%s].", timeChunk, TooManySegmentsInTimeChunkFault.convertToGranularityString(segmentGranularity), numSegments, maxNumSegments, "maxNumSegments");
        this.timeChunk = timeChunk;
        this.numSegments = numSegments;
        this.maxNumSegments = maxNumSegments;
        this.segmentGranularity = segmentGranularity;
    }

    private static String convertToGranularityString(Granularity granularity) {
        for (GranularityType value : GranularityType.values()) {
            if (!value.getDefaultGranularity().equals(granularity)) continue;
            return value.name();
        }
        return granularity.toString();
    }

    @JsonProperty
    public DateTime getTimeChunk() {
        return this.timeChunk;
    }

    @JsonProperty
    public int getNumSegments() {
        return this.numSegments;
    }

    @JsonProperty
    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @JsonProperty
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManySegmentsInTimeChunkFault that = (TooManySegmentsInTimeChunkFault)o;
        return this.numSegments == that.numSegments && this.maxNumSegments == that.maxNumSegments && Objects.equals(this.timeChunk, that.timeChunk) && Objects.equals(this.segmentGranularity, that.segmentGranularity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeChunk, this.numSegments, this.maxNumSegments, this.segmentGranularity);
    }
}

