/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics.serde;

import java.nio.ByteBuffer;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.msq.statistics.DistinctKeySnapshot;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.serde.KeyCollectorSnapshotSerializer;

public class DistinctSnapshotSerializer
extends KeyCollectorSnapshotSerializer {
    public static final byte TYPE = 1;

    @Override
    protected byte getType() {
        return 1;
    }

    @Override
    protected byte[] serializeKeyCollector(KeyCollectorSnapshot collectorSnapshot) {
        DistinctKeySnapshot snapshot = (DistinctKeySnapshot)collectorSnapshot;
        int length = 8;
        for (SerializablePair<RowKey, Long> key : snapshot.getKeys()) {
            length += ((RowKey)key.lhs).array().length + 4 + 8;
        }
        ByteBuffer buffer = ByteBuffer.allocate(length).putInt(snapshot.getSpaceReductionFactor()).putInt(snapshot.getKeys().size());
        for (SerializablePair<RowKey, Long> key : snapshot.getKeys()) {
            byte[] array = ((RowKey)key.lhs).array();
            buffer.putLong((Long)key.rhs).putInt(array.length).put(array);
        }
        return buffer.array();
    }
}

