/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.conglomerate.Sort;
import org.apache.derby.iapi.store.access.conglomerate.SortFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;

public class ExternalSortFactory
implements SortFactory,
ModuleControl,
ModuleSupportable,
SortCostController {
    private boolean userSpecified;
    private int defaultSortBufferMax;
    private int sortBufferMax;
    private static final String IMPLEMENTATIONID = "sort external";
    private static final String FORMATUUIDSTRING = "D2976090-D9F5-11d0-B54D-00A024BF8879";
    private UUID formatUUID = null;
    private static final int DEFAULT_SORTBUFFERMAX = 1024;
    private static final int MINIMUM_SORTBUFFERMAX = 4;
    protected static final int DEFAULT_MEM_USE = 0x100000;
    protected static final int DEFAULT_MAX_MERGE_RUN = 512;
    private static final int SORT_ROW_OVERHEAD = 44;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String string) {
        return string.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID uUID) {
        return uUID.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    protected MergeSort getMergeSort() {
        return new MergeSort();
    }

    @Override
    public Sort createSort(TransactionController transactionController, int n, Properties properties, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, SortObserver sortObserver, boolean bl, long l, int n2) throws StandardException {
        MergeSort mergeSort = this.getMergeSort();
        if (!this.userSpecified) {
            this.sortBufferMax = n2 > 0 ? 0x100000 / (n2 += 44 + dataValueDescriptorArray.length * 16 + 8) : this.defaultSortBufferMax;
            if (l > (long)this.sortBufferMax && (double)l * 1.1 < (double)(this.sortBufferMax * 2)) {
                this.sortBufferMax = (int)(l / 2L + l / 10L);
            }
            if (this.sortBufferMax < 4) {
                this.sortBufferMax = 4;
            }
        } else {
            this.sortBufferMax = this.defaultSortBufferMax;
        }
        mergeSort.initialize(dataValueDescriptorArray, columnOrderingArray, sortObserver, bl, l, this.sortBufferMax);
        return mergeSort;
    }

    @Override
    public SortCostController openSortCostController() throws StandardException {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public double getSortCost(DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, boolean bl, long l, long l2, int n) throws StandardException {
        if (l == 0L) {
            return 0.0;
        }
        double d = 1.0 + 0.32 * (double)l * Math.log(l);
        return d;
    }

    @Override
    public boolean canSupport(Properties properties) {
        if (properties == null) {
            return false;
        }
        String string = properties.getProperty("derby.access.Conglomerate.type");
        if (string == null) {
            return false;
        }
        return this.supportsImplementation(string);
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        UUIDFactory uUIDFactory = ExternalSortFactory.getMonitor().getUUIDFactory();
        this.formatUUID = uUIDFactory.recreateUUID(FORMATUUIDSTRING);
        this.defaultSortBufferMax = PropertyUtil.getSystemInt("derby.storage.sortBufferMax", 0, Integer.MAX_VALUE, 0);
        if (this.defaultSortBufferMax == 0) {
            this.userSpecified = false;
            this.defaultSortBufferMax = 1024;
        } else {
            this.userSpecified = true;
            if (this.defaultSortBufferMax < 4) {
                this.defaultSortBufferMax = 4;
            }
        }
    }

    @Override
    public void stop() {
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

