/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.s3.S3DataSegmentPuller;

@JsonTypeName(value="s3_zip")
public class S3LoadSpec
implements LoadSpec {
    private final String bucket;
    private final String key;
    private final S3DataSegmentPuller puller;

    @JsonCreator
    public S3LoadSpec(@JacksonInject S3DataSegmentPuller puller, @JsonProperty(value="bucket") String bucket, @JsonProperty(value="key") String key) {
        Preconditions.checkNotNull((Object)bucket);
        Preconditions.checkNotNull((Object)key);
        this.bucket = bucket;
        this.key = key;
        this.puller = puller;
    }

    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(new CloudObjectLocation(this.bucket, this.key), outDir).size());
    }

    @JsonProperty(value="bucket")
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }
}

