/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.segment.cache.CacheStats;
import org.apache.druid.metadata.segment.cache.ReadWriteCache;
import org.apache.druid.metadata.segment.cache.SegmentRecord;
import org.apache.druid.metadata.segment.cache.SegmentSyncResult;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

class HeapMemoryDatasourceSegmentCache
extends ReadWriteCache
implements AutoCloseable {
    private final String dataSource;
    private final TreeMap<Interval, SegmentsInInterval> intervalToSegments = new TreeMap(Comparators.intervalsByEndThenStart());
    private final AtomicInteger references = new AtomicInteger(0);

    HeapMemoryDatasourceSegmentCache(String dataSource) {
        super(true);
        this.dataSource = dataSource;
    }

    @Override
    public void stop() {
        this.withWriteLock(() -> {
            this.intervalToSegments.values().forEach(SegmentsInInterval::clear);
            this.intervalToSegments.clear();
            super.stop();
        });
    }

    boolean isEmpty() {
        return (Boolean)this.withReadLock(this.intervalToSegments::isEmpty);
    }

    void acquireReference() {
        this.references.incrementAndGet();
    }

    @Override
    public void close() {
        this.references.decrementAndGet();
    }

    boolean isBeingUsedByTransaction() {
        return this.references.get() > 0;
    }

    private static boolean shouldUpdateCache(@Nullable DateTime cachedUpdateTime, @Nullable DateTime newUpdateTime) {
        if (newUpdateTime == null) {
            return false;
        }
        return cachedUpdateTime == null || cachedUpdateTime.isBefore((ReadableInstant)newUpdateTime);
    }

    SegmentSyncResult syncSegmentIds(List<SegmentRecord> persistedSegments, DateTime syncStartTime) {
        return (SegmentSyncResult)this.withWriteLock(() -> {
            HashSet<SegmentId> usedSegmentIdsToRefresh = new HashSet<SegmentId>();
            for (SegmentRecord record : persistedSegments) {
                SegmentId segmentId = record.getSegmentId();
                SegmentsInInterval intervalSegments = this.writeSegmentsFor(segmentId.getInterval());
                if (!record.isUsed() || !intervalSegments.shouldRefreshSegment(segmentId, record.getLastUpdatedTime())) continue;
                usedSegmentIdsToRefresh.add(segmentId);
            }
            Set<SegmentId> persistedSegmentIds = persistedSegments.stream().map(SegmentRecord::getSegmentId).collect(Collectors.toSet());
            int numSegmentsRemoved = this.removeUnpersistedSegments(persistedSegmentIds, syncStartTime);
            return new SegmentSyncResult(numSegmentsRemoved, 0, usedSegmentIdsToRefresh);
        });
    }

    SegmentSyncResult syncPendingSegments(List<PendingSegmentRecord> persistedPendingSegments, DateTime syncStartTime) {
        return (SegmentSyncResult)this.withWriteLock(() -> {
            int numSegmentsUpdated = 0;
            for (PendingSegmentRecord record : persistedPendingSegments) {
                if (!this.insertPendingSegment(record, false)) continue;
                ++numSegmentsUpdated;
            }
            Set<String> persistedSegmentIds = persistedPendingSegments.stream().map(s -> s.getId().toString()).collect(Collectors.toSet());
            int numSegmentsRemoved = this.removeUnpersistedPendingSegments(persistedSegmentIds, syncStartTime);
            return new SegmentSyncResult(numSegmentsRemoved, numSegmentsUpdated, Set.of());
        });
    }

    private int removeUnpersistedPendingSegments(Set<String> persistedPendingSegmentIds, DateTime pollStartTime) {
        return (Integer)this.withWriteLock(() -> {
            Set<String> unpersistedSegmentIds = this.findPendingSegmentsMatching(record -> !persistedPendingSegmentIds.contains(record.getId().toString()) && HeapMemoryDatasourceSegmentCache.shouldUpdateCache(record.getCreatedDate(), pollStartTime)).stream().map(record -> record.getId().toString()).collect(Collectors.toSet());
            return this.deletePendingSegments(unpersistedSegmentIds);
        });
    }

    private int removeUnpersistedSegments(Set<SegmentId> persistedSegmentIds, DateTime syncStartTime) {
        return (Integer)this.withWriteLock(() -> {
            HashSet<SegmentId> unpersistedSegmentIds = new HashSet<SegmentId>();
            for (SegmentsInInterval segments : this.intervalToSegments.values()) {
                segments.unusedSegmentIdToUpdatedTime.entrySet().stream().filter(entry -> !persistedSegmentIds.contains(entry.getKey()) && HeapMemoryDatasourceSegmentCache.shouldUpdateCache((DateTime)entry.getValue(), syncStartTime)).map(Map.Entry::getKey).forEach(unpersistedSegmentIds::add);
                segments.idToUsedSegment.entrySet().stream().filter(entry -> !persistedSegmentIds.contains(entry.getKey()) && HeapMemoryDatasourceSegmentCache.shouldUpdateCache(((DataSegmentPlus)entry.getValue()).getUsedStatusLastUpdatedDate(), syncStartTime)).map(Map.Entry::getKey).forEach(unpersistedSegmentIds::add);
            }
            return this.deleteSegments(unpersistedSegmentIds);
        });
    }

    CacheStats markCacheSynced() {
        return (CacheStats)this.withWriteLock(() -> {
            Set<Interval> emptyIntervals = this.intervalToSegments.entrySet().stream().filter(entry -> ((SegmentsInInterval)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
            emptyIntervals.forEach(this.intervalToSegments::remove);
            return this.getCacheStats();
        });
    }

    private CacheStats getCacheStats() {
        return (CacheStats)this.withWriteLock(() -> {
            int numUsedSegments = 0;
            int numUnusedSegments = 0;
            int numPendingSegments = 0;
            int numIntervals = 0;
            for (SegmentsInInterval segments : this.intervalToSegments.values()) {
                ++numIntervals;
                numUsedSegments += segments.idToUsedSegment.size();
                numUnusedSegments += segments.unusedSegmentIdToUpdatedTime.size();
                numPendingSegments += segments.idToPendingSegment.size();
            }
            return new CacheStats(numIntervals, numUsedSegments, numUnusedSegments, numPendingSegments);
        });
    }

    private SegmentsInInterval readSegmentsFor(Interval interval) {
        return this.intervalToSegments.getOrDefault(interval, SegmentsInInterval.EMPTY);
    }

    private SegmentsInInterval writeSegmentsFor(Interval interval) {
        return this.intervalToSegments.computeIfAbsent(interval, i -> new SegmentsInInterval());
    }

    @Override
    public Set<String> findExistingSegmentIds(Set<SegmentId> segments) {
        throw DruidException.defensive((String)"Unsupported: Unused segments are not cached", (Object[])new Object[0]);
    }

    @Override
    public Set<SegmentId> findUsedSegmentIdsOverlapping(Interval interval) {
        return this.findUsedSegmentsPlusOverlappingAnyOf(List.of(interval)).stream().map(s -> s.getDataSegment().getId()).collect(Collectors.toSet());
    }

    @Override
    public SegmentId findHighestUnusedSegmentId(Interval interval, String version) {
        throw DruidException.defensive((String)"Unsupported: Unused segments are not cached", (Object[])new Object[0]);
    }

    @Override
    public Set<DataSegment> findUsedSegmentsOverlappingAnyOf(List<Interval> intervals) {
        return this.findUsedSegmentsPlusOverlappingAnyOf(intervals).stream().map(DataSegmentPlus::getDataSegment).collect(Collectors.toSet());
    }

    @Override
    public List<DataSegmentPlus> findUsedSegments(Set<SegmentId> segmentIds) {
        return (List)this.withReadLock(() -> segmentIds.stream().map(id -> this.readSegmentsFor((Interval)id.getInterval()).idToUsedSegment.get(id)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public Set<DataSegmentPlus> findUsedSegmentsPlusOverlappingAnyOf(List<Interval> intervals) {
        if (intervals.isEmpty()) {
            return (Set)this.withReadLock(() -> this.intervalToSegments.values().stream().flatMap(segments -> segments.idToUsedSegment.values().stream()).collect(Collectors.toSet()));
        }
        return (Set)this.withReadLock(() -> intervals.stream().flatMap(this::findOverlappingIntervals).flatMap(segments -> segments.idToUsedSegment.values().stream()).collect(Collectors.toSet()));
    }

    @Override
    public DataSegment findSegment(SegmentId segmentId) {
        throw DruidException.defensive((String)"Unsupported: Unused segments are not cached", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public DataSegment findUsedSegment(SegmentId segmentId) {
        return (DataSegment)this.withReadLock(() -> {
            DataSegmentPlus segmentPlus = this.readSegmentsFor((Interval)segmentId.getInterval()).idToUsedSegment.get(segmentId);
            return segmentPlus == null ? null : segmentPlus.getDataSegment();
        });
    }

    @Override
    public List<DataSegmentPlus> findSegments(Set<SegmentId> segmentIds) {
        throw DruidException.defensive((String)"Unsupported: Unused segments are not cached", (Object[])new Object[0]);
    }

    @Override
    public List<DataSegmentPlus> findSegmentsWithSchema(Set<SegmentId> segmentIds) {
        throw DruidException.defensive((String)"Unsupported: Unused segments are not cached", (Object[])new Object[0]);
    }

    @Override
    public List<DataSegment> findUnusedSegments(Interval interval, @Nullable List<String> versions, @Nullable Integer limit, @Nullable DateTime maxUpdatedTime) {
        throw DruidException.defensive((String)"Unsupported: Unused segments are not cached", (Object[])new Object[0]);
    }

    @Override
    public List<SegmentIdWithShardSpec> findPendingSegmentIds(String sequenceName, String sequencePreviousId) {
        return this.findPendingSegmentsMatching(record -> sequenceName.equals(record.getSequenceName()) && sequencePreviousId.equals(record.getSequencePrevId())).stream().map(PendingSegmentRecord::getId).collect(Collectors.toList());
    }

    @Override
    public List<SegmentIdWithShardSpec> findPendingSegmentIdsWithExactInterval(String sequenceName, Interval interval) {
        return (List)this.withReadLock(() -> this.readSegmentsFor((Interval)interval).idToPendingSegment.values().stream().filter(record -> record.getSequenceName().equals(sequenceName)).map(PendingSegmentRecord::getId).collect(Collectors.toList()));
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegmentsOverlapping(Interval interval) {
        return (List)this.withReadLock(() -> this.findOverlappingIntervals(interval).flatMap(segments -> segments.idToPendingSegment.values().stream()).collect(Collectors.toList()));
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegmentsWithExactInterval(Interval interval) {
        return (List)this.withReadLock(() -> List.copyOf(this.readSegmentsFor((Interval)interval).idToPendingSegment.values()));
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegments(String taskAllocatorId) {
        return this.findPendingSegmentsMatching(record -> taskAllocatorId.equals(record.getTaskAllocatorId()));
    }

    @Override
    public int insertSegments(Set<DataSegmentPlus> segments) {
        return (Integer)this.withWriteLock(() -> {
            int numInsertedSegments = 0;
            for (DataSegmentPlus segmentPlus : segments) {
                Interval interval = segmentPlus.getDataSegment().getInterval();
                if (!this.writeSegmentsFor(interval).addSegment(segmentPlus)) continue;
                ++numInsertedSegments;
            }
            return numInsertedSegments;
        });
    }

    @Override
    public int insertSegmentsWithMetadata(Set<DataSegmentPlus> segments) {
        return this.insertSegments(segments);
    }

    @Override
    public boolean markSegmentAsUnused(SegmentId segmentId, DateTime updateTime) {
        return this.writeSegmentsFor(segmentId.getInterval()).markSegmentAsUnused(segmentId, updateTime);
    }

    @Override
    public int markSegmentsAsUnused(Set<SegmentId> segmentIds, DateTime updateTime) {
        return (Integer)this.withWriteLock(() -> {
            int updatedCount = 0;
            for (SegmentId segmentId : segmentIds) {
                Interval interval = segmentId.getInterval();
                if (!this.writeSegmentsFor(interval).markSegmentAsUnused(segmentId, updateTime)) continue;
                ++updatedCount;
            }
            return updatedCount;
        });
    }

    @Override
    public int markSegmentsWithinIntervalAsUnused(Interval interval, @Nullable List<String> versions, DateTime updateTime) {
        Set<String> eligibleVersions = versions == null ? null : Set.copyOf(versions);
        return (Integer)this.withWriteLock(() -> {
            int updatedCount = 0;
            for (DataSegmentPlus segmentPlus : this.findUsedSegmentsPlusOverlappingAnyOf(List.of(interval))) {
                DataSegment segment = segmentPlus.getDataSegment();
                boolean isEligibleVersion = eligibleVersions == null || eligibleVersions.contains(segment.getVersion());
                if (!isEligibleVersion || !this.writeSegmentsFor(segment.getInterval()).markSegmentAsUnused(segment.getId(), updateTime)) continue;
                ++updatedCount;
            }
            return updatedCount;
        });
    }

    @Override
    public int markAllSegmentsAsUnused(DateTime updateTime) {
        return (Integer)this.withWriteLock(() -> {
            int updatedCount = 0;
            for (DataSegmentPlus segmentPlus : this.findUsedSegmentsPlusOverlappingAnyOf(List.of())) {
                DataSegment segment = segmentPlus.getDataSegment();
                if (!this.writeSegmentsFor(segment.getInterval()).markSegmentAsUnused(segment.getId(), updateTime)) continue;
                ++updatedCount;
            }
            return updatedCount;
        });
    }

    @Override
    public int deleteSegments(Set<SegmentId> segmentIdsToDelete) {
        return (Integer)this.withWriteLock(() -> {
            int deletedCount = 0;
            for (SegmentId segmentId : segmentIdsToDelete) {
                if (segmentId == null || !this.writeSegmentsFor(segmentId.getInterval()).removeSegment(segmentId)) continue;
                ++deletedCount;
            }
            return deletedCount;
        });
    }

    @Override
    public boolean updateSegmentPayload(DataSegment segment) {
        throw DruidException.defensive((String)"Unsupported: Segment payload updates are not supported in the cache", (Object[])new Object[0]);
    }

    @Override
    public boolean insertPendingSegment(PendingSegmentRecord pendingSegment, boolean skipSegmentLineageCheck) {
        return this.insertPendingSegments(List.of(pendingSegment), skipSegmentLineageCheck) > 0;
    }

    @Override
    public int insertPendingSegments(List<PendingSegmentRecord> pendingSegments, boolean skipSegmentLineageCheck) {
        return (Integer)this.withWriteLock(() -> {
            int insertedCount = 0;
            for (PendingSegmentRecord record : pendingSegments) {
                SegmentIdWithShardSpec segmentId = record.getId();
                PendingSegmentRecord oldValue = this.writeSegmentsFor((Interval)segmentId.getInterval()).idToPendingSegment.putIfAbsent(segmentId.toString(), record);
                if (oldValue != null) continue;
                ++insertedCount;
            }
            return insertedCount;
        });
    }

    @Override
    public int deleteAllPendingSegments() {
        return (Integer)this.withWriteLock(() -> {
            int numPendingSegments = this.intervalToSegments.values().stream().mapToInt(interval -> interval.idToPendingSegment.size()).sum();
            this.intervalToSegments.values().forEach(interval -> interval.idToPendingSegment.clear());
            return numPendingSegments;
        });
    }

    @Override
    public int deletePendingSegments(Set<String> segmentIdsToDelete) {
        HashSet<String> remainingIdsToDelete = new HashSet<String>(segmentIdsToDelete);
        this.withWriteLock(() -> this.intervalToSegments.forEach((interval, segments) -> {
            Set deletedIds = remainingIdsToDelete.stream().map(segments.idToPendingSegment::remove).filter(Objects::nonNull).map(record -> record.getId().toString()).collect(Collectors.toSet());
            remainingIdsToDelete.removeAll(deletedIds);
        }));
        return segmentIdsToDelete.size() - remainingIdsToDelete.size();
    }

    @Override
    public int deletePendingSegments(String taskAllocatorId) {
        return (Integer)this.withWriteLock(() -> {
            Set<String> idsToDelete = this.findPendingSegmentsMatching(record -> taskAllocatorId.equals(record.getTaskAllocatorId())).stream().map(record -> record.getId().toString()).collect(Collectors.toSet());
            return this.deletePendingSegments(idsToDelete);
        });
    }

    @Override
    public int deletePendingSegmentsCreatedIn(Interval interval) {
        return (Integer)this.withWriteLock(() -> {
            Set<String> idsToDelete = this.findPendingSegmentsMatching(record -> interval.contains((ReadableInstant)record.getCreatedDate())).stream().map(record -> record.getId().toString()).collect(Collectors.toSet());
            return this.deletePendingSegments(idsToDelete);
        });
    }

    private List<PendingSegmentRecord> findPendingSegmentsMatching(Predicate<PendingSegmentRecord> predicate) {
        return (List)this.withReadLock(() -> this.intervalToSegments.values().stream().flatMap(interval -> interval.idToPendingSegment.values().stream()).filter(predicate).collect(Collectors.toList()));
    }

    private Stream<SegmentsInInterval> findOverlappingIntervals(Interval searchInterval) {
        if (Intervals.isEternity((Interval)searchInterval)) {
            return (Stream)this.withReadLock(() -> this.intervalToSegments.values().stream());
        }
        Interval overlapStart = Intervals.ETERNITY.withEnd((ReadableInstant)searchInterval.getStart());
        return (Stream)this.withReadLock(() -> this.intervalToSegments.tailMap(overlapStart).entrySet().stream().filter(entry -> ((Interval)entry.getKey()).overlaps((ReadableInterval)searchInterval)).map(Map.Entry::getValue));
    }

    private static class SegmentsInInterval {
        static final SegmentsInInterval EMPTY = new SegmentsInInterval();
        final Map<SegmentId, DataSegmentPlus> idToUsedSegment = new HashMap<SegmentId, DataSegmentPlus>();
        final Map<String, PendingSegmentRecord> idToPendingSegment = new HashMap<String, PendingSegmentRecord>();
        final Map<SegmentId, DateTime> unusedSegmentIdToUpdatedTime = new HashMap<SegmentId, DateTime>();

        private SegmentsInInterval() {
        }

        void clear() {
            this.idToPendingSegment.clear();
            this.idToUsedSegment.clear();
            this.unusedSegmentIdToUpdatedTime.clear();
        }

        boolean isEmpty() {
            return this.idToPendingSegment.isEmpty() && this.idToUsedSegment.isEmpty() && this.unusedSegmentIdToUpdatedTime.isEmpty();
        }

        private boolean removeSegment(SegmentId segmentId) {
            if (this.idToUsedSegment.containsKey(segmentId)) {
                this.idToUsedSegment.remove(segmentId);
                return true;
            }
            if (this.unusedSegmentIdToUpdatedTime.containsKey(segmentId)) {
                this.unusedSegmentIdToUpdatedTime.remove(segmentId);
                return true;
            }
            return false;
        }

        boolean addSegment(DataSegmentPlus segmentPlus) {
            SegmentId segmentId = segmentPlus.getDataSegment().getId();
            if (!this.shouldRefreshSegment(segmentId, segmentPlus.getUsedStatusLastUpdatedDate())) {
                return false;
            }
            if (Boolean.TRUE.equals(segmentPlus.getUsed())) {
                this.idToUsedSegment.put(segmentId, segmentPlus);
                this.unusedSegmentIdToUpdatedTime.remove(segmentId);
                return true;
            }
            return this.markSegmentAsUnused(segmentId, segmentPlus.getUsedStatusLastUpdatedDate());
        }

        private boolean markSegmentAsUnused(SegmentId segmentId, @Nullable DateTime updatedTime) {
            if (this.shouldRefreshSegment(segmentId, updatedTime)) {
                this.idToUsedSegment.remove(segmentId);
                this.unusedSegmentIdToUpdatedTime.put(segmentId, updatedTime);
                return true;
            }
            return false;
        }

        private boolean shouldRefreshSegment(SegmentId segmentId, DateTime newUpdateTime) {
            if (this.unusedSegmentIdToUpdatedTime.containsKey(segmentId)) {
                return HeapMemoryDatasourceSegmentCache.shouldUpdateCache(this.unusedSegmentIdToUpdatedTime.get(segmentId), newUpdateTime);
            }
            DataSegmentPlus usedSegment = this.idToUsedSegment.get(segmentId);
            return usedSegment == null || HeapMemoryDatasourceSegmentCache.shouldUpdateCache(usedSegment.getUsedStatusLastUpdatedDate(), newUpdateTime);
        }
    }
}

