/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.CoordinatorSegmentMetadataCache;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.server.JettyUtils;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/metadata")
public class MetadataResource {
    private static final Logger log = new Logger(MetadataResource.class);
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final AuthorizerMapper authorizerMapper;
    private final DruidCoordinator coordinator;
    @Nullable
    private final CoordinatorSegmentMetadataCache coordinatorSegmentMetadataCache;

    @Inject
    public MetadataResource(SegmentsMetadataManager segmentsMetadataManager, IndexerMetadataStorageCoordinator metadataStorageCoordinator, AuthorizerMapper authorizerMapper, DruidCoordinator coordinator, @Nullable CoordinatorSegmentMetadataCache coordinatorSegmentMetadataCache) {
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
        this.authorizerMapper = authorizerMapper;
        this.coordinator = coordinator;
        this.coordinatorSegmentMetadataCache = coordinatorSegmentMetadataCache;
    }

    @GET
    @Path(value="/datasources")
    @Produces(value={"application/json"})
    public Response getDataSources(@QueryParam(value="full") String full, @Context UriInfo uriInfo, @Context HttpServletRequest req) {
        TreeSet dataSourceNamesPreAuth;
        boolean includeUnused = JettyUtils.getQueryParam(uriInfo, "includeUnused", "includeDisabled") != null;
        Collection<ImmutableDruidDataSource> druidDataSources = null;
        if (includeUnused) {
            dataSourceNamesPreAuth = new TreeSet(this.metadataStorageCoordinator.retrieveAllDatasourceNames());
        } else {
            druidDataSources = this.segmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSourcesWithAllUsedSegments();
            dataSourceNamesPreAuth = druidDataSources.stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toCollection(TreeSet::new));
        }
        TreeSet dataSourceNamesPostAuth = new TreeSet();
        Function raGenerator = datasourceName -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply(datasourceName));
        Iterables.addAll(dataSourceNamesPostAuth, AuthorizationUtils.filterAuthorizedResources(req, dataSourceNamesPreAuth, raGenerator, this.authorizerMapper));
        if (full != null && !includeUnused) {
            return Response.ok().entity((Object)Collections2.filter(druidDataSources, dataSource -> dataSourceNamesPostAuth.contains(dataSource.getName()))).build();
        }
        return Response.ok().entity(dataSourceNamesPostAuth).build();
    }

    @GET
    @Path(value="/segments")
    @Produces(value={"application/json"})
    public Response getAllUsedSegments(@Context HttpServletRequest req, @QueryParam(value="datasources") @Nullable Set<String> dataSources, @QueryParam(value="includeOvershadowedStatus") @Nullable String includeOvershadowedStatus, @QueryParam(value="includeRealtimeSegments") @Nullable String includeRealtimeSegments) {
        try {
            if (includeOvershadowedStatus == null && includeRealtimeSegments != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (includeOvershadowedStatus != null) {
                return this.getAllUsedSegmentsWithAdditionalDetails(req, dataSources, includeRealtimeSegments);
            }
            Collection dataSourcesWithUsedSegments = this.segmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSourcesWithAllUsedSegments();
            if (dataSources != null && !dataSources.isEmpty()) {
                dataSourcesWithUsedSegments = dataSourcesWithUsedSegments.stream().filter(dataSourceWithUsedSegments -> dataSources.contains(dataSourceWithUsedSegments.getName())).collect(Collectors.toList());
            }
            Stream usedSegments = dataSourcesWithUsedSegments.stream().flatMap(t -> t.getSegments().stream());
            Function raGenerator = segment -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources(req, usedSegments::iterator, raGenerator, this.authorizerMapper);
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
            return builder.entity(authorizedSegments).build();
        }
        catch (DruidException e) {
            return ServletResourceUtils.buildErrorResponseFrom(e);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while fetching used segment information.", new Object[0]);
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.toString())).build();
        }
    }

    private Response getAllUsedSegmentsWithAdditionalDetails(HttpServletRequest req, @Nullable Set<String> dataSources, String includeRealtimeSegments) {
        Stream<SegmentStatusInCluster> segmentStatus;
        DataSourcesSnapshot dataSourcesSnapshot = this.segmentsMetadataManager.getRecentDataSourcesSnapshot();
        Collection dataSourcesWithUsedSegments = dataSourcesSnapshot.getDataSourcesWithAllUsedSegments();
        if (dataSources != null && !dataSources.isEmpty()) {
            dataSourcesWithUsedSegments = dataSourcesWithUsedSegments.stream().filter(dataSourceWithUsedSegments -> dataSources.contains(dataSourceWithUsedSegments.getName())).collect(Collectors.toList());
        }
        ImmutableSet<DataSegment> overshadowedSegments = dataSourcesSnapshot.getOvershadowedSegments();
        HashSet segmentAlreadySeen = new HashSet();
        Stream<SegmentStatusInCluster> finalSegments = segmentStatus = dataSourcesWithUsedSegments.stream().flatMap(t -> t.getSegments().stream()).map(segment -> {
            AvailableSegmentMetadata availableSegmentMetadata;
            boolean isOvershadowed = overshadowedSegments.contains(segment);
            Integer replicationFactor = isOvershadowed ? Integer.valueOf(0) : this.coordinator.getReplicationFactor(segment.getId());
            Long numRows = null;
            if (this.coordinatorSegmentMetadataCache != null && null != (availableSegmentMetadata = this.coordinatorSegmentMetadataCache.getAvailableSegmentMetadata(segment.getDataSource(), segment.getId()))) {
                numRows = availableSegmentMetadata.getNumRows();
            }
            segmentAlreadySeen.add(segment.getId());
            return new SegmentStatusInCluster(segment, isOvershadowed, replicationFactor, numRows, false);
        });
        if (includeRealtimeSegments != null && this.coordinatorSegmentMetadataCache != null) {
            Stream<SegmentStatusInCluster> realtimeSegmentStatus = this.coordinatorSegmentMetadataCache.getSegmentMetadataSnapshot().values().stream().filter(availableSegmentMetadata -> !segmentAlreadySeen.contains(availableSegmentMetadata.getSegment().getId())).map(availableSegmentMetadata -> new SegmentStatusInCluster(availableSegmentMetadata.getSegment(), false, null, Long.valueOf(availableSegmentMetadata.getNumRows()), availableSegmentMetadata.isRealtime() != 0L));
            finalSegments = Stream.concat(segmentStatus, realtimeSegmentStatus);
        }
        Function raGenerator = segment -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSegment().getDataSource()));
        Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources(req, finalSegments::iterator, raGenerator, this.authorizerMapper);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        return builder.entity(authorizedSegments).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDataSourceWithUsedSegments(@PathParam(value="dataSourceName") String dataSourceName) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)dataSource).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getUsedSegmentsInDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") @Nullable String full) {
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Collections2.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @POST
    @Path(value="/datasources/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getUsedSegmentsInDataSourceForIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") @Nullable String full, List<Interval> intervals) {
        Set<DataSegment> segments = this.metadataStorageCoordinator.retrieveUsedSegmentsForIntervals(dataSourceName, intervals, Segments.INCLUDING_OVERSHADOWED);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK);
        if (full != null) {
            return builder.entity(segments).build();
        }
        return builder.entity((Object)Collections2.transform(segments, DataSegment::getId)).build();
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/unusedSegments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getUnusedSegmentsInDataSource(@Context HttpServletRequest req, @PathParam(value="dataSourceName") String dataSource, @QueryParam(value="interval") @Nullable String interval, @QueryParam(value="limit") @Nullable Integer limit, @QueryParam(value="lastSegmentId") @Nullable String lastSegmentId, @QueryParam(value="sortOrder") @Nullable String sortOrder) {
        try {
            if (dataSource == null || dataSource.isEmpty()) {
                throw InvalidInput.exception((String)"dataSourceName must be non-empty.", (Object[])new Object[0]);
            }
            if (limit != null && limit < 0) {
                throw InvalidInput.exception((String)"Invalid limit[%s] specified. Limit must be > 0.", (Object[])new Object[]{limit});
            }
            if (lastSegmentId != null && SegmentId.tryParse((String)dataSource, (String)lastSegmentId) == null) {
                throw InvalidInput.exception((String)"Invalid lastSegmentId[%s] specified.", (Object[])new Object[]{lastSegmentId});
            }
            SortOrder theSortOrder = sortOrder == null ? null : SortOrder.fromValue(sortOrder);
            Interval theInterval = interval != null ? Intervals.of((String)interval.replace('_', '/')) : null;
            List<DataSegmentPlus> unusedSegments = this.metadataStorageCoordinator.iterateAllUnusedSegmentsForDatasource(dataSource, theInterval, limit, lastSegmentId, theSortOrder);
            ArrayList retVal = new ArrayList();
            unusedSegments.iterator().forEachRemaining(retVal::add);
            return Response.status((Response.Status)Response.Status.OK).entity(retVal).build();
        }
        catch (DruidException e) {
            return ServletResourceUtils.buildErrorResponseFrom(e);
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred.", (Object)"message", (Object)Throwables.getRootCause((Throwable)e).toString())).build();
        }
    }

    @GET
    @Path(value="/datasources/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String serializedSegmentId, @QueryParam(value="includeUnused") @Nullable Boolean includeUnused) {
        SegmentId segmentId = SegmentId.tryParse((String)dataSourceName, (String)serializedSegmentId);
        if (segmentId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringUtils.format((String)"Could not parse Segment ID[%s] for DataSource[%s]", (Object[])new Object[]{StringUtils.escapeHtml((String)serializedSegmentId), StringUtils.escapeHtml((String)dataSourceName)})).build();
        }
        ImmutableDruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        DataSegment segment = dataSource.getSegment(segmentId);
        if (segment != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        segment = Boolean.TRUE.equals(includeUnused) ? this.metadataStorageCoordinator.retrieveSegmentForId(segmentId) : this.metadataStorageCoordinator.retrieveUsedSegmentForId(segmentId);
        if (segment != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)segment).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Path(value="/dataSourceInformation")
    @Produces(value={"application/json"})
    public Response getDataSourceInformation(@Context HttpServletRequest req, List<String> dataSources) {
        if (this.coordinatorSegmentMetadataCache == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Map<String, DataSourceInformation> dataSourceSchemaMap = this.coordinatorSegmentMetadataCache.getDataSourceInformationMap();
        ArrayList<DataSourceInformation> results = new ArrayList<DataSourceInformation>();
        for (Map.Entry<String, DataSourceInformation> entry : dataSourceSchemaMap.entrySet()) {
            if (!dataSources.contains(entry.getKey())) continue;
            results.add(entry.getValue());
        }
        Function raGenerator = dataSourceInformation -> Collections.singletonList((ResourceAction)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)dataSourceInformation.getDataSource()));
        Iterable authorizedDataSourceInformation = AuthorizationUtils.filterAuthorizedResources(req, results, raGenerator, this.authorizerMapper);
        return Response.status((Response.Status)Response.Status.OK).entity(authorizedDataSourceInformation).build();
    }

    @POST
    @Path(value="/bootstrapSegments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getBootstrapSegments() {
        Set<DataSegment> broadcastSegments = this.coordinator.getBroadcastSegments();
        if (broadcastSegments == null) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Bootstrap segments are not initialized yet. Please ensure that the Coordinator duties are running and try again.").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(broadcastSegments).build();
    }

    private ImmutableDruidDataSource getDataSource(String dataSource) {
        return this.segmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSource(dataSource);
    }
}

