/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1HTTPIngressPathBuilder;
import io.kubernetes.client.openapi.models.V1HTTPIngressPathFluentImpl;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValue;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValueFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1HTTPIngressRuleValueFluentImpl<A extends V1HTTPIngressRuleValueFluent<A>>
extends BaseFluent<A>
implements V1HTTPIngressRuleValueFluent<A> {
    private ArrayList<V1HTTPIngressPathBuilder> paths;

    public V1HTTPIngressRuleValueFluentImpl() {
    }

    public V1HTTPIngressRuleValueFluentImpl(V1HTTPIngressRuleValue instance) {
        if (instance != null) {
            this.withPaths(instance.getPaths());
        }
    }

    @Override
    public A addToPaths(int index, V1HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get("paths").add(index, builder);
            this.paths.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPaths(int index, V1HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this.paths.size()) {
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        } else {
            this._visitables.get("paths").set(index, builder);
            this.paths.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPaths(V1HTTPIngressPath ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<V1HTTPIngressPath> items) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(V1HTTPIngressPath ... items) {
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").remove(builder);
            if (this.paths == null) continue;
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<V1HTTPIngressPath> items) {
        for (V1HTTPIngressPath item : items) {
            V1HTTPIngressPathBuilder builder = new V1HTTPIngressPathBuilder(item);
            this._visitables.get("paths").remove(builder);
            if (this.paths == null) continue;
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPaths(Predicate<V1HTTPIngressPathBuilder> predicate) {
        if (this.paths == null) {
            return (A)this;
        }
        Iterator<V1HTTPIngressPathBuilder> each = this.paths.iterator();
        Object visitables = this._visitables.get("paths");
        while (each.hasNext()) {
            V1HTTPIngressPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1HTTPIngressPath> getPaths() {
        return this.paths != null ? V1HTTPIngressRuleValueFluentImpl.build(this.paths) : null;
    }

    @Override
    public List<V1HTTPIngressPath> buildPaths() {
        return this.paths != null ? V1HTTPIngressRuleValueFluentImpl.build(this.paths) : null;
    }

    @Override
    public V1HTTPIngressPath buildPath(int index) {
        return this.paths.get(index).build();
    }

    @Override
    public V1HTTPIngressPath buildFirstPath() {
        return this.paths.get(0).build();
    }

    @Override
    public V1HTTPIngressPath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    @Override
    public V1HTTPIngressPath buildMatchingPath(Predicate<V1HTTPIngressPathBuilder> predicate) {
        for (V1HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<V1HTTPIngressPathBuilder> predicate) {
        for (V1HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<V1HTTPIngressPath> paths) {
        if (this.paths != null) {
            this._visitables.get("paths").clear();
        }
        if (paths != null) {
            this.paths = new ArrayList();
            for (V1HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(V1HTTPIngressPath ... paths) {
        if (this.paths != null) {
            this.paths.clear();
            this._visitables.remove("paths");
        }
        if (paths != null) {
            for (V1HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> addNewPath() {
        return new PathsNestedImpl();
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> addNewPathLike(V1HTTPIngressPath item) {
        return new PathsNestedImpl(-1, item);
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> setNewPathLike(int index, V1HTTPIngressPath item) {
        return new PathsNestedImpl(index, item);
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> editPath(int index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public V1HTTPIngressRuleValueFluent.PathsNested<A> editMatchingPath(Predicate<V1HTTPIngressPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.test(this.paths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HTTPIngressRuleValueFluentImpl that = (V1HTTPIngressRuleValueFluentImpl)o;
        return Objects.equals(this.paths, that.paths);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.paths, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.paths != null) {
            sb.append("paths:");
            sb.append(this.paths);
        }
        sb.append("}");
        return sb.toString();
    }

    class PathsNestedImpl<N>
    extends V1HTTPIngressPathFluentImpl<V1HTTPIngressRuleValueFluent.PathsNested<N>>
    implements V1HTTPIngressRuleValueFluent.PathsNested<N>,
    Nested<N> {
        V1HTTPIngressPathBuilder builder;
        int index;

        PathsNestedImpl(int index, V1HTTPIngressPath item) {
            this.index = index;
            this.builder = new V1HTTPIngressPathBuilder(this, item);
        }

        PathsNestedImpl() {
            this.index = -1;
            this.builder = new V1HTTPIngressPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1HTTPIngressRuleValueFluentImpl.this.setToPaths(this.index, this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }
}

