/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;

public class MaxSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.MAX;
    }

    @Override
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName) {
        ColumnType valueType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (valueType == null) {
            return null;
        }
        return Aggregation.create(MaxSqlAggregator.createMaxAggregatorFactory(valueType, name, fieldName, macroTable));
    }

    private static AggregatorFactory createMaxAggregatorFactory(ColumnType aggregationType, String name, String fieldName, ExprMacroTable macroTable) {
        switch ((ValueType)aggregationType.getType()) {
            case LONG: {
                return new LongMaxAggregatorFactory(name, fieldName, null, macroTable);
            }
            case FLOAT: {
                return new FloatMaxAggregatorFactory(name, fieldName, null, macroTable);
            }
            case DOUBLE: {
                return new DoubleMaxAggregatorFactory(name, fieldName, null, macroTable);
            }
        }
        throw SimpleSqlAggregator.badTypeException(fieldName, "MAX", aggregationType);
    }
}

