/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class PositionOperatorConversion
implements SqlOperatorConversion {
    private static final DruidExpression ZERO = DruidExpression.ofLiteral(ColumnType.LONG, "0");

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.POSITION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.LONG, args -> {
            DruidExpression fromIndexExpression = args.size() > 2 ? DruidExpression.ofExpression(ColumnType.LONG, _args -> StringUtils.format((String)"(%s - 1)", (Object[])new Object[]{((DruidExpression)_args.get(2)).getExpression()}), args) : ZERO;
            return StringUtils.format((String)"(%s + 1)", (Object[])new Object[]{DruidExpression.functionCall("strpos", (List<DruidExpression>)ImmutableList.of((Object)((DruidExpression)args.get(1)), (Object)((DruidExpression)args.get(0)), (Object)fromIndexExpression))});
        }, druidExpressions));
    }
}

