/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication;

import com.google.common.annotations.VisibleForTesting;
import java.security.Principal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.directory.SearchResult;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentials;
import org.apache.druid.security.basic.authentication.validator.PasswordHashGenerator;

public class LdapUserPrincipal
implements Principal {
    private static final Logger LOG = new Logger(LdapUserPrincipal.class);
    private final String name;
    private final BasicAuthenticatorCredentials credentials;
    private final SearchResult searchResult;
    private final Instant createdAt;
    private final AtomicReference<Instant> lastVerified = new AtomicReference();

    public LdapUserPrincipal(String name, BasicAuthenticatorCredentials credentials, SearchResult searchResult) {
        this(name, credentials, searchResult, Instant.now());
    }

    @VisibleForTesting
    public LdapUserPrincipal(String name, BasicAuthenticatorCredentials credentials, SearchResult searchResult, Instant createdAt) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(credentials, "credentials is required");
        Objects.requireNonNull(searchResult, "searchResult is required");
        Objects.requireNonNull(createdAt, "createdAt is required");
        this.name = name;
        this.credentials = credentials;
        this.searchResult = searchResult;
        this.createdAt = createdAt;
        this.lastVerified.set(createdAt);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getLastVerified() {
        return this.lastVerified.get();
    }

    public boolean hasSameCredentials(char[] password, PasswordHashGenerator hashGenerator) {
        byte[] recalculatedHash = hashGenerator.getOrComputePasswordHash(password, this.credentials.getSalt(), this.credentials.getIterations());
        if (Arrays.equals(recalculatedHash, this.credentials.getHash())) {
            this.lastVerified.set(Instant.now());
            LOG.debug("Refereshing lastVerified principal user '%s'", new Object[]{this.name});
            return true;
        }
        return false;
    }

    public boolean isExpired(int durationSeconds, int maxDurationSeconds) {
        return this.isExpired(durationSeconds, maxDurationSeconds, System.currentTimeMillis());
    }

    @VisibleForTesting
    boolean isExpired(int durationSeconds, int maxDurationSeconds, long nowMillis) {
        long maxCutoffMillis = nowMillis - (long)maxDurationSeconds * 1000L;
        if (this.createdAt.toEpochMilli() < maxCutoffMillis) {
            return true;
        }
        long cutoffMillis = nowMillis - (long)durationSeconds * 1000L;
        return this.lastVerified.get().toEpochMilli() < cutoffMillis;
    }

    @Override
    public String toString() {
        return StringUtils.format((String)"LdapUserPrincipal[name=%s, searchResult=%s, createdAt=%s, lastVerified=%s]", (Object[])new Object[]{this.name, this.searchResult, this.createdAt, this.lastVerified});
    }
}

