/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.provider.token;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEDecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.DirectDecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.ECDSAVerifier;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.MACVerifier;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSADecrypter;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.RSASSAVerifier;
import org.apache.hadoop.shaded.com.nimbusds.jwt.EncryptedJWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.JWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.JWTParser;
import org.apache.hadoop.shaded.com.nimbusds.jwt.PlainJWT;
import org.apache.hadoop.shaded.com.nimbusds.jwt.SignedJWT;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.provider.token.JwtAuthToken;

public class JwtTokenDecoder
implements TokenDecoder {
    private Object decryptionKey;
    private Object verifyKey;
    private List<String> audiences = null;
    private boolean signed = false;

    @Override
    public AuthToken decodeFromBytes(byte[] content) throws IOException {
        String tokenStr = new String(content, StandardCharsets.UTF_8);
        return this.decodeFromString(tokenStr);
    }

    @Override
    public AuthToken decodeFromString(String content) throws IOException {
        JWT jwt = null;
        try {
            jwt = JWTParser.parse(content);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse JWT token string", e);
        }
        if (jwt instanceof PlainJWT) {
            PlainJWT plainObject = (PlainJWT)jwt;
            try {
                if (this.verifyToken(jwt)) {
                    return new JwtAuthToken(plainObject.getJWTClaimsSet());
                }
                return null;
            }
            catch (ParseException e) {
                throw new IOException("Failed to get JWT claims set", e);
            }
        }
        if (jwt instanceof EncryptedJWT) {
            EncryptedJWT encryptedJWT = (EncryptedJWT)jwt;
            this.decryptEncryptedJWT(encryptedJWT);
            SignedJWT signedJWT = encryptedJWT.getPayload().toSignedJWT();
            if (signedJWT != null) {
                boolean success;
                boolean bl = success = this.verifySignedJWT(signedJWT) && this.verifyToken(signedJWT);
                if (success) {
                    try {
                        this.signed = true;
                        return new JwtAuthToken(signedJWT.getJWTClaimsSet());
                    }
                    catch (ParseException e) {
                        throw new IOException("Failed to get JWT claims set", e);
                    }
                }
                return null;
            }
            try {
                if (this.verifyToken(encryptedJWT)) {
                    return new JwtAuthToken(encryptedJWT.getJWTClaimsSet());
                }
                return null;
            }
            catch (ParseException e) {
                throw new IOException("Failed to get JWT claims set", e);
            }
        }
        if (jwt instanceof SignedJWT) {
            boolean success;
            SignedJWT signedJWT = (SignedJWT)jwt;
            boolean bl = success = this.verifySignedJWT(signedJWT) && this.verifyToken(signedJWT);
            if (success) {
                try {
                    this.signed = true;
                    return new JwtAuthToken(signedJWT.getJWTClaimsSet());
                }
                catch (ParseException e) {
                    throw new IOException("Failed to get JWT claims set", e);
                }
            }
            return null;
        }
        throw new IOException("Unexpected JWT type: " + jwt);
    }

    public void decryptEncryptedJWT(EncryptedJWT encryptedJWT) throws IOException {
        try {
            JWEDecrypter decrypter = this.getDecrypter();
            encryptedJWT.decrypt(decrypter);
        }
        catch (JOSEException | KrbException e) {
            throw new IOException("Failed to decrypt the encrypted JWT", e);
        }
    }

    private JWEDecrypter getDecrypter() throws JOSEException, KrbException {
        if (this.decryptionKey instanceof RSAPrivateKey) {
            return new RSADecrypter((RSAPrivateKey)this.decryptionKey);
        }
        if (this.decryptionKey instanceof byte[]) {
            return new DirectDecrypter((byte[])this.decryptionKey);
        }
        throw new KrbException("An unknown decryption key was specified");
    }

    @Override
    public void setDecryptionKey(PrivateKey key) {
        this.decryptionKey = key;
    }

    @Override
    public void setDecryptionKey(byte[] key) {
        this.decryptionKey = key == null ? (Object)new byte[0] : key.clone();
    }

    public boolean verifySignedJWT(SignedJWT signedJWT) throws IOException {
        try {
            JWSVerifier verifier = this.getVerifier();
            return signedJWT.verify(verifier);
        }
        catch (JOSEException | KrbException e) {
            throw new IOException("Failed to verify the signed JWT", e);
        }
    }

    private JWSVerifier getVerifier() throws JOSEException, KrbException {
        if (this.verifyKey instanceof RSAPublicKey) {
            return new RSASSAVerifier((RSAPublicKey)this.verifyKey);
        }
        if (this.verifyKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)this.verifyKey;
            return new ECDSAVerifier(ecPublicKey.getW().getAffineX(), ecPublicKey.getW().getAffineY());
        }
        if (this.verifyKey instanceof byte[]) {
            return new MACVerifier((byte[])this.verifyKey);
        }
        throw new KrbException("An unknown verify key was specified");
    }

    @Override
    public void setVerifyKey(PublicKey key) {
        this.verifyKey = key;
    }

    @Override
    public void setVerifyKey(byte[] key) {
        this.verifyKey = key == null ? (Object)new byte[0] : key.clone();
    }

    public void setAudiences(List<String> auds) {
        this.audiences = auds;
    }

    private boolean verifyToken(JWT jwtToken) throws IOException {
        boolean audValid = this.verifyAudiences(jwtToken);
        boolean expValid = this.verifyExpiration(jwtToken);
        return audValid && expValid;
    }

    private boolean verifyAudiences(JWT jwtToken) throws IOException {
        boolean valid;
        block4: {
            valid = false;
            try {
                List tokenAudiences = jwtToken.getJWTClaimsSet().getAudience();
                if (this.audiences == null) {
                    valid = true;
                    break block4;
                }
                for (String audience : tokenAudiences) {
                    if (!this.audiences.contains(audience)) continue;
                    valid = true;
                    break;
                }
            }
            catch (ParseException e) {
                throw new IOException("Failed to get JWT claims set", e);
            }
        }
        return valid;
    }

    private boolean verifyExpiration(JWT jwtToken) throws IOException {
        try {
            Date expire = jwtToken.getJWTClaimsSet().getExpirationTime();
            if (expire != null && new Date().after(expire)) {
                return false;
            }
            Date notBefore = jwtToken.getJWTClaimsSet().getNotBeforeTime();
            if (notBefore != null && new Date().before(notBefore)) {
                return false;
            }
        }
        catch (ParseException e) {
            throw new IOException("Failed to get JWT claims set", e);
        }
        return true;
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }
}

