/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cluster.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClientImpl;
import org.apache.druid.testing.cluster.ClusterTestingTaskConfig;
import org.joda.time.Duration;

public class FaultyOverlordClient
extends OverlordClientImpl {
    private static final Logger log = new Logger(FaultyOverlordClient.class);
    private final ObjectMapper jsonMapper;
    private final ServiceClient serviceClient;
    private final ClusterTestingTaskConfig.OverlordClientConfig testingConfig;

    @Inject
    public FaultyOverlordClient(ClusterTestingTaskConfig.OverlordClientConfig testingConfig, @Json ObjectMapper jsonMapper, @IndexingService ServiceClient serviceClient) {
        super(serviceClient, jsonMapper);
        this.jsonMapper = jsonMapper;
        this.serviceClient = serviceClient;
        this.testingConfig = testingConfig;
        log.info("Initialized FaultyOverlordClient with config[%s]", new Object[]{testingConfig});
    }

    public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
        this.addDelayIfConfigured();
        return super.taskStatuses(state, dataSource, maxCompletedTasks);
    }

    public ListenableFuture<Map<String, TaskStatus>> taskStatuses(Set<String> taskIds) {
        this.addDelayIfConfigured();
        return super.taskStatuses(taskIds);
    }

    public ListenableFuture<TaskStatusResponse> taskStatus(String taskId) {
        this.addDelayIfConfigured();
        return super.taskStatus(taskId);
    }

    public OverlordClientImpl withRetryPolicy(ServiceRetryPolicy retryPolicy) {
        return new FaultyOverlordClient(this.testingConfig, this.jsonMapper, this.serviceClient);
    }

    private void addDelayIfConfigured() {
        Duration delay = this.testingConfig.getTaskStatusDelay();
        if (delay == null) {
            return;
        }
        try {
            log.info("Sleeping for [%s] before calling Overlord", new Object[]{delay});
            Thread.sleep(delay.getMillis());
        }
        catch (InterruptedException e) {
            log.info("Interrupted while sleeping before task action.", new Object[0]);
        }
    }
}

