/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Union;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class SketchAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector selector;
    private final int size;
    @Nullable
    private Union union;

    public SketchAggregator(BaseObjectColumnValueSelector selector, int size) {
        this.selector = selector;
        this.size = size;
    }

    private void initUnion() {
        this.union = (Union)SetOperation.builder().setNominalEntries(this.size).build(Family.UNION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate() {
        Object update = this.selector.getObject();
        if (update == null) {
            return;
        }
        SketchAggregator sketchAggregator = this;
        synchronized (sketchAggregator) {
            if (this.union == null) {
                this.initUnion();
            }
            SketchAggregator.updateUnion(this.union, update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long aggregateWithSize() {
        Object update = this.selector.getObject();
        if (update == null) {
            return 0L;
        }
        SketchAggregator sketchAggregator = this;
        synchronized (sketchAggregator) {
            long unionSizeDelta = 0L;
            long initialSketchSize = 0L;
            if (this.union == null) {
                this.initUnion();
                unionSizeDelta = 40L;
            } else {
                initialSketchSize = this.union.getCurrentBytes();
            }
            SketchAggregator.updateUnion(this.union, update);
            long sketchSizeDelta = (long)this.union.getCurrentBytes() - initialSketchSize;
            return sketchSizeDelta + unionSizeDelta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        if (this.union == null) {
            return SketchHolder.EMPTY;
        }
        SketchAggregator sketchAggregator = this;
        synchronized (sketchAggregator) {
            return SketchHolder.of(this.union.getResult(true, null));
        }
    }

    public float getFloat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.union = null;
    }

    static void updateUnion(Union union, Object update) {
        if (update instanceof SketchHolder) {
            ((SketchHolder)update).updateUnion(union);
        } else if (update instanceof String) {
            union.update((String)update);
        } else if (update instanceof byte[]) {
            union.update((byte[])update);
        } else if (update instanceof Double) {
            union.update(((Double)update).doubleValue());
        } else if (update instanceof Integer || update instanceof Long) {
            union.update(((Number)update).longValue());
        } else if (update instanceof int[]) {
            union.update((int[])update);
        } else if (update instanceof long[]) {
            union.update((long[])update);
        } else if (update instanceof List) {
            for (Object entry : (List)update) {
                String asString;
                if (entry == null || (asString = entry.toString()) == null) continue;
                union.update(asString);
            }
        } else {
            throw new ISE("Illegal type received while theta sketch merging [%s]", new Object[]{update.getClass()});
        }
    }

    public long getInitialSizeBytes() {
        return 48L;
    }
}

