/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.fastutil;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;

public class DruidIntList
extends IntArrayList {
    public DruidIntList(int capacity) {
        super(capacity);
    }

    public void addArray(int[] vals) {
        this.grow(this.size + vals.length);
        System.arraycopy(vals, 0, this.a, this.size, vals.length);
        this.size += vals.length;
    }

    public void fill(int val, int count) {
        this.grow(this.size + count);
        Arrays.fill(this.a, this.size, this.size + count, val);
        this.size += count;
    }

    public void fillWithRepeat(int[] vals, int repeat) {
        int count = vals.length * repeat;
        this.grow(this.size + count);
        for (int i = 0; i < count; i += vals.length) {
            System.arraycopy(vals, 0, this.a, this.size + i, vals.length);
        }
        this.size += count;
    }

    public void fillRuns(int[] vals, int runLength, int repeat) {
        if (runLength == 1) {
            this.fillWithRepeat(vals, repeat);
            return;
        }
        int count = vals.length * runLength * repeat;
        this.grow(this.size + count);
        for (int i = 0; i < repeat; ++i) {
            for (int val : vals) {
                Arrays.fill(this.a, this.size, this.size += runLength, val);
            }
        }
    }

    public void resetToSize(int targetSize) {
        this.a = new int[targetSize];
        this.size = 0;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != IntArrays.DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = IntArrays.forceCapacity((int[])this.a, (int)capacity, (int)this.size);
        assert (this.size <= this.a.length);
    }
}

