/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DelimitedBytes;
import org.apache.druid.data.input.impl.DelimitedValueReader;
import org.apache.druid.data.input.impl.FlatTextInputFormat;
import org.apache.druid.java.util.common.StringUtils;

public class DelimitedInputFormat
extends FlatTextInputFormat {
    public static final String TYPE_KEY = "tsv";
    private static final String DEFAULT_DELIMITER = "\t";

    @JsonCreator
    public DelimitedInputFormat(@JsonProperty(value="columns") @Nullable List<String> columns, @JsonProperty(value="listDelimiter") @Nullable String listDelimiter, @JsonProperty(value="delimiter") @Nullable String delimiter, @Deprecated @JsonProperty(value="hasHeaderRow") @Nullable Boolean hasHeaderRow, @JsonProperty(value="findColumnsFromHeader") @Nullable Boolean findColumnsFromHeader, @JsonProperty(value="skipHeaderRows") int skipHeaderRows, @JsonProperty(value="tryParseNumbers") @Nullable Boolean tryParseNumbers) {
        super(columns, listDelimiter, delimiter == null ? DEFAULT_DELIMITER : delimiter, hasHeaderRow, findColumnsFromHeader, skipHeaderRows, tryParseNumbers);
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new DelimitedValueReader(inputRowSchema, source, this.getListDelimiter(), this.getColumns(), this.isFindColumnsFromHeader(), this.getSkipHeaderRows(), DelimitedInputFormat.makeDelimitedValueParser(this.getDelimiter(), this.useListBasedInputRows() ? this.getColumns().size() : -1), this.useListBasedInputRows(), this.shouldTryParseNumbers());
    }

    private static DelimitedValueReader.DelimitedValueParser makeDelimitedValueParser(String delimiter, int numFields) {
        byte[] utf8Delimiter = StringUtils.toUtf8(delimiter);
        if (utf8Delimiter.length == 1) {
            byte delimiterByte = utf8Delimiter[0];
            return bytes -> DelimitedBytes.split(bytes, delimiterByte, numFields);
        }
        Splitter splitter = Splitter.on((String)delimiter);
        return bytes -> DelimitedInputFormat.splitToList(splitter, StringUtils.fromUtf8(bytes));
    }

    public static List<String> splitToList(Splitter splitter, String input) {
        Preconditions.checkNotNull((Object)input);
        Iterator iterator = splitter.split((CharSequence)input).iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            String splitValue = (String)iterator.next();
            if (splitValue.isEmpty()) {
                result.add(null);
                continue;
            }
            result.add(splitValue);
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "DelimitedInputFormat{" + this.fieldsToString() + "}";
    }
}

