/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;

public class OutputChannels {
    private final List<OutputChannel> outputChannels;
    private final Int2ObjectSortedMap<List<OutputChannel>> partitionToChannelMap;

    private OutputChannels(List<OutputChannel> outputChannels) {
        this.outputChannels = outputChannels;
        this.partitionToChannelMap = new Int2ObjectRBTreeMap();
        for (OutputChannel outputChannel : outputChannels) {
            ((List)this.partitionToChannelMap.computeIfAbsent(outputChannel.getPartitionNumber(), ignored -> new ArrayList())).add(outputChannel);
        }
    }

    public static OutputChannels none() {
        return OutputChannels.wrap(Collections.emptyList());
    }

    public static OutputChannels wrap(List<OutputChannel> outputChannels) {
        return new OutputChannels(outputChannels);
    }

    public OutputChannels verifySingleChannel() {
        IntBidirectionalIterator intBidirectionalIterator = this.getPartitionNumbers().iterator();
        while (intBidirectionalIterator.hasNext()) {
            int partitionNumber = (Integer)intBidirectionalIterator.next();
            List<OutputChannel> outputChannelsForPartition = this.getChannelsForPartition(partitionNumber);
            Preconditions.checkState((partitionNumber >= 0 ? 1 : 0) != 0, (String)"Expected partitionNumber >= 0, but got [%s]", (int)partitionNumber);
            Preconditions.checkState((outputChannelsForPartition.size() == 1 ? 1 : 0) != 0, (String)"Expected one channel for partition [%s], but got [%s]", (int)partitionNumber, (int)outputChannelsForPartition.size());
        }
        return this;
    }

    public IntSortedSet getPartitionNumbers() {
        return this.partitionToChannelMap.keySet();
    }

    public List<OutputChannel> getAllChannels() {
        return this.outputChannels;
    }

    public List<ReadableFrameChannel> getAllReadableChannels() {
        return this.outputChannels.stream().map(OutputChannel::getReadableChannel).collect(Collectors.toList());
    }

    public List<OutputChannel> getChannelsForPartition(int partitionNumber) {
        List retVal = (List)this.partitionToChannelMap.get(partitionNumber);
        if (retVal != null) {
            return retVal;
        }
        return Collections.emptyList();
    }

    public OutputChannels readOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return new OutputChannels(this.outputChannels.stream().map(OutputChannel::readOnly).collect(Collectors.toList()));
    }

    public boolean isReadOnly() {
        for (OutputChannel channel : this.outputChannels) {
            if (channel.isReadOnly()) continue;
            return false;
        }
        return true;
    }
}

